// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    public partial class NicIPSettings : IUtf8JsonSerializable, IJsonModel<NicIPSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NicIPSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NicIPSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NicIPSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NicIPSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AllocationMethod))
            {
                writer.WritePropertyName("allocationMethod"u8);
                writer.WriteStringValue(AllocationMethod.Value.ToString());
            }
            if (Optional.IsCollectionDefined(DnsServers))
            {
                writer.WritePropertyName("dnsServers"u8);
                writer.WriteStartArray();
                foreach (var item in DnsServers)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Gateway))
            {
                writer.WritePropertyName("gateway"u8);
                writer.WriteStartArray();
                foreach (var item in Gateway)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IPAddress))
            {
                writer.WritePropertyName("ipAddress"u8);
                writer.WriteStringValue(IPAddress);
            }
            if (Optional.IsDefined(SubnetMask))
            {
                writer.WritePropertyName("subnetMask"u8);
                writer.WriteStringValue(SubnetMask);
            }
            if (options.Format != "W" && Optional.IsDefined(PrimaryWinsServer))
            {
                writer.WritePropertyName("primaryWinsServer"u8);
                writer.WriteStringValue(PrimaryWinsServer);
            }
            if (options.Format != "W" && Optional.IsDefined(SecondaryWinsServer))
            {
                writer.WritePropertyName("secondaryWinsServer"u8);
                writer.WriteStringValue(SecondaryWinsServer);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(IPAddressInfo))
            {
                writer.WritePropertyName("ipAddressInfo"u8);
                writer.WriteStartArray();
                foreach (var item in IPAddressInfo)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NicIPSettings IJsonModel<NicIPSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NicIPSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NicIPSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNicIPSettings(document.RootElement, options);
        }

        internal static NicIPSettings DeserializeNicIPSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IPAddressAllocationMethod? allocationMethod = default;
            IList<string> dnsServers = default;
            IList<string> gateway = default;
            string ipAddress = default;
            string subnetMask = default;
            string primaryWinsServer = default;
            string secondaryWinsServer = default;
            IReadOnlyList<NicIPAddressSettings> ipAddressInfo = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("allocationMethod"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allocationMethod = new IPAddressAllocationMethod(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dnsServers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    dnsServers = array;
                    continue;
                }
                if (property.NameEquals("gateway"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    gateway = array;
                    continue;
                }
                if (property.NameEquals("ipAddress"u8))
                {
                    ipAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subnetMask"u8))
                {
                    subnetMask = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("primaryWinsServer"u8))
                {
                    primaryWinsServer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondaryWinsServer"u8))
                {
                    secondaryWinsServer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ipAddressInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<NicIPAddressSettings> array = new List<NicIPAddressSettings>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(NicIPAddressSettings.DeserializeNicIPAddressSettings(item, options));
                    }
                    ipAddressInfo = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NicIPSettings(
                allocationMethod,
                dnsServers ?? new ChangeTrackingList<string>(),
                gateway ?? new ChangeTrackingList<string>(),
                ipAddress,
                subnetMask,
                primaryWinsServer,
                secondaryWinsServer,
                ipAddressInfo ?? new ChangeTrackingList<NicIPAddressSettings>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NicIPSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NicIPSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NicIPSettings)} does not support writing '{options.Format}' format.");
            }
        }

        NicIPSettings IPersistableModel<NicIPSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NicIPSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNicIPSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NicIPSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NicIPSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
