// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the different types of operations for guest agent. </summary>
    public readonly partial struct GuestAgentProvisioningAction : IEquatable<GuestAgentProvisioningAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GuestAgentProvisioningAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GuestAgentProvisioningAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstallValue = "install";
        private const string UninstallValue = "uninstall";
        private const string RepairValue = "repair";

        /// <summary> install. </summary>
        public static GuestAgentProvisioningAction Install { get; } = new GuestAgentProvisioningAction(InstallValue);
        /// <summary> uninstall. </summary>
        public static GuestAgentProvisioningAction Uninstall { get; } = new GuestAgentProvisioningAction(UninstallValue);
        /// <summary> repair. </summary>
        public static GuestAgentProvisioningAction Repair { get; } = new GuestAgentProvisioningAction(RepairValue);
        /// <summary> Determines if two <see cref="GuestAgentProvisioningAction"/> values are the same. </summary>
        public static bool operator ==(GuestAgentProvisioningAction left, GuestAgentProvisioningAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GuestAgentProvisioningAction"/> values are not the same. </summary>
        public static bool operator !=(GuestAgentProvisioningAction left, GuestAgentProvisioningAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GuestAgentProvisioningAction"/>. </summary>
        public static implicit operator GuestAgentProvisioningAction(string value) => new GuestAgentProvisioningAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GuestAgentProvisioningAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GuestAgentProvisioningAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
