// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    internal class VmInstanceGuestAgentOperationSource : IOperationSource<VmInstanceGuestAgentResource>
    {
        private readonly ArmClient _client;

        internal VmInstanceGuestAgentOperationSource(ArmClient client)
        {
            _client = client;
        }

        VmInstanceGuestAgentResource IOperationSource<VmInstanceGuestAgentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VmInstanceGuestAgentData.DeserializeVmInstanceGuestAgentData(document.RootElement);
            return new VmInstanceGuestAgentResource(_client, data);
        }

        async ValueTask<VmInstanceGuestAgentResource> IOperationSource<VmInstanceGuestAgentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VmInstanceGuestAgentData.DeserializeVmInstanceGuestAgentData(document.RootElement);
            return new VmInstanceGuestAgentResource(_client, data);
        }
    }
}
