// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    internal class VMwareVmTemplateOperationSource : IOperationSource<VMwareVmTemplateResource>
    {
        private readonly ArmClient _client;

        internal VMwareVmTemplateOperationSource(ArmClient client)
        {
            _client = client;
        }

        VMwareVmTemplateResource IOperationSource<VMwareVmTemplateResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VMwareVmTemplateData.DeserializeVMwareVmTemplateData(document.RootElement);
            return new VMwareVmTemplateResource(_client, data);
        }

        async ValueTask<VMwareVmTemplateResource> IOperationSource<VMwareVmTemplateResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VMwareVmTemplateData.DeserializeVMwareVmTemplateData(document.RootElement);
            return new VMwareVmTemplateResource(_client, data);
        }
    }
}
