// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    internal class VMwareVirtualNetworkOperationSource : IOperationSource<VMwareVirtualNetworkResource>
    {
        private readonly ArmClient _client;

        internal VMwareVirtualNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        VMwareVirtualNetworkResource IOperationSource<VMwareVirtualNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VMwareVirtualNetworkData.DeserializeVMwareVirtualNetworkData(document.RootElement);
            return new VMwareVirtualNetworkResource(_client, data);
        }

        async ValueTask<VMwareVirtualNetworkResource> IOperationSource<VMwareVirtualNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VMwareVirtualNetworkData.DeserializeVMwareVirtualNetworkData(document.RootElement);
            return new VMwareVirtualNetworkResource(_client, data);
        }
    }
}
