// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    internal class VMwareVCenterOperationSource : IOperationSource<VMwareVCenterResource>
    {
        private readonly ArmClient _client;

        internal VMwareVCenterOperationSource(ArmClient client)
        {
            _client = client;
        }

        VMwareVCenterResource IOperationSource<VMwareVCenterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VMwareVCenterData.DeserializeVMwareVCenterData(document.RootElement);
            return new VMwareVCenterResource(_client, data);
        }

        async ValueTask<VMwareVCenterResource> IOperationSource<VMwareVCenterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VMwareVCenterData.DeserializeVMwareVCenterData(document.RootElement);
            return new VMwareVCenterResource(_client, data);
        }
    }
}
