// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    internal class VMwareDatastoreOperationSource : IOperationSource<VMwareDatastoreResource>
    {
        private readonly ArmClient _client;

        internal VMwareDatastoreOperationSource(ArmClient client)
        {
            _client = client;
        }

        VMwareDatastoreResource IOperationSource<VMwareDatastoreResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VMwareDatastoreData.DeserializeVMwareDatastoreData(document.RootElement);
            return new VMwareDatastoreResource(_client, data);
        }

        async ValueTask<VMwareDatastoreResource> IOperationSource<VMwareDatastoreResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VMwareDatastoreData.DeserializeVMwareDatastoreData(document.RootElement);
            return new VMwareDatastoreResource(_client, data);
        }
    }
}
