// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Confluent.Models
{
    public partial class SchemaRegistryClusterSpecEntity : IUtf8JsonSerializable, IJsonModel<SchemaRegistryClusterSpecEntity>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SchemaRegistryClusterSpecEntity>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SchemaRegistryClusterSpecEntity>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SchemaRegistryClusterSpecEntity>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SchemaRegistryClusterSpecEntity)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(HttpEndpoint))
            {
                writer.WritePropertyName("httpEndpoint"u8);
                writer.WriteStringValue(HttpEndpoint);
            }
            if (Optional.IsDefined(Package))
            {
                writer.WritePropertyName("package"u8);
                writer.WriteStringValue(Package);
            }
            if (Optional.IsDefined(Region))
            {
                writer.WritePropertyName("region"u8);
                writer.WriteObjectValue(Region, options);
            }
            if (Optional.IsDefined(Environment))
            {
                writer.WritePropertyName("environment"u8);
                writer.WriteObjectValue(Environment, options);
            }
            if (Optional.IsDefined(Cloud))
            {
                writer.WritePropertyName("cloud"u8);
                writer.WriteStringValue(Cloud);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SchemaRegistryClusterSpecEntity IJsonModel<SchemaRegistryClusterSpecEntity>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SchemaRegistryClusterSpecEntity>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SchemaRegistryClusterSpecEntity)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSchemaRegistryClusterSpecEntity(document.RootElement, options);
        }

        internal static SchemaRegistryClusterSpecEntity DeserializeSchemaRegistryClusterSpecEntity(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string httpEndpoint = default;
            string package = default;
            SchemaRegistryClusterEnvironmentRegionEntity region = default;
            SchemaRegistryClusterEnvironmentRegionEntity environment = default;
            string cloud = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("httpEndpoint"u8))
                {
                    httpEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("package"u8))
                {
                    package = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("region"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    region = SchemaRegistryClusterEnvironmentRegionEntity.DeserializeSchemaRegistryClusterEnvironmentRegionEntity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("environment"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    environment = SchemaRegistryClusterEnvironmentRegionEntity.DeserializeSchemaRegistryClusterEnvironmentRegionEntity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("cloud"u8))
                {
                    cloud = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SchemaRegistryClusterSpecEntity(
                name,
                httpEndpoint,
                package,
                region,
                environment,
                cloud,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SchemaRegistryClusterSpecEntity>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SchemaRegistryClusterSpecEntity>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SchemaRegistryClusterSpecEntity)} does not support writing '{options.Format}' format.");
            }
        }

        SchemaRegistryClusterSpecEntity IPersistableModel<SchemaRegistryClusterSpecEntity>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SchemaRegistryClusterSpecEntity>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSchemaRegistryClusterSpecEntity(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SchemaRegistryClusterSpecEntity)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SchemaRegistryClusterSpecEntity>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
