// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Region spec details. </summary>
    public partial class RegionSpecEntity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RegionSpecEntity"/>. </summary>
        internal RegionSpecEntity()
        {
            Packages = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="RegionSpecEntity"/>. </summary>
        /// <param name="name"> Display Name of the region. </param>
        /// <param name="cloud"> Cloud provider name. </param>
        /// <param name="regionName"> Region name. </param>
        /// <param name="packages"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RegionSpecEntity(string name, string cloud, string regionName, IReadOnlyList<string> packages, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Cloud = cloud;
            RegionName = regionName;
            Packages = packages;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display Name of the region. </summary>
        public string Name { get; }
        /// <summary> Cloud provider name. </summary>
        public string Cloud { get; }
        /// <summary> Region name. </summary>
        public string RegionName { get; }
        /// <summary> Gets the packages. </summary>
        public IReadOnlyList<string> Packages { get; }
    }
}
