// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Details of region record. </summary>
    public partial class ConfluentRegionRecord
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConfluentRegionRecord"/>. </summary>
        internal ConfluentRegionRecord()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConfluentRegionRecord"/>. </summary>
        /// <param name="kind"> Kind of the cluster. </param>
        /// <param name="id"> Id of the cluster. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="spec"> Specification of the region. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConfluentRegionRecord(string kind, string id, SCMetadataEntity metadata, RegionSpecEntity spec, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Id = id;
            Metadata = metadata;
            Spec = spec;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Kind of the cluster. </summary>
        public string Kind { get; }
        /// <summary> Id of the cluster. </summary>
        public string Id { get; }
        /// <summary> Metadata of the record. </summary>
        public SCMetadataEntity Metadata { get; }
        /// <summary> Specification of the region. </summary>
        public RegionSpecEntity Spec { get; }
    }
}
