// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Metadata of the list. </summary>
    public partial class ConfluentListMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConfluentListMetadata"/>. </summary>
        internal ConfluentListMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConfluentListMetadata"/>. </summary>
        /// <param name="first"> First page of the list. </param>
        /// <param name="last"> Last page of the list. </param>
        /// <param name="prev"> Previous page of the list. </param>
        /// <param name="next"> Next page of the list. </param>
        /// <param name="totalSize"> Total size of the list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConfluentListMetadata(string first, string last, string prev, string next, int? totalSize, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            First = first;
            Last = last;
            Prev = prev;
            Next = next;
            TotalSize = totalSize;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> First page of the list. </summary>
        public string First { get; }
        /// <summary> Last page of the list. </summary>
        public string Last { get; }
        /// <summary> Previous page of the list. </summary>
        public string Prev { get; }
        /// <summary> Next page of the list. </summary>
        public string Next { get; }
        /// <summary> Total size of the list. </summary>
        public int? TotalSize { get; }
    }
}
