// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Confluent.Models
{
    public partial class ConfluentListMetadata : IUtf8JsonSerializable, IJsonModel<ConfluentListMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConfluentListMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConfluentListMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentListMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConfluentListMetadata)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(First))
            {
                writer.WritePropertyName("first"u8);
                writer.WriteStringValue(First);
            }
            if (Optional.IsDefined(Last))
            {
                writer.WritePropertyName("last"u8);
                writer.WriteStringValue(Last);
            }
            if (Optional.IsDefined(Prev))
            {
                writer.WritePropertyName("prev"u8);
                writer.WriteStringValue(Prev);
            }
            if (Optional.IsDefined(Next))
            {
                writer.WritePropertyName("next"u8);
                writer.WriteStringValue(Next);
            }
            if (Optional.IsDefined(TotalSize))
            {
                writer.WritePropertyName("total_size"u8);
                writer.WriteNumberValue(TotalSize.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConfluentListMetadata IJsonModel<ConfluentListMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentListMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConfluentListMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConfluentListMetadata(document.RootElement, options);
        }

        internal static ConfluentListMetadata DeserializeConfluentListMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string first = default;
            string last = default;
            string prev = default;
            string next = default;
            int? totalSize = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("first"u8))
                {
                    first = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("last"u8))
                {
                    last = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("prev"u8))
                {
                    prev = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("next"u8))
                {
                    next = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("total_size"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalSize = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConfluentListMetadata(
                first,
                last,
                prev,
                next,
                totalSize,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConfluentListMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentListMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConfluentListMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        ConfluentListMetadata IPersistableModel<ConfluentListMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentListMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConfluentListMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConfluentListMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConfluentListMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
