// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Spec of the cluster record. </summary>
    public partial class ClusterSpecEntity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterSpecEntity"/>. </summary>
        internal ClusterSpecEntity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterSpecEntity"/>. </summary>
        /// <param name="displayName"> The name of the cluster. </param>
        /// <param name="availability"> The availability zone configuration of the cluster. </param>
        /// <param name="cloud"> The cloud service provider. </param>
        /// <param name="zone"> type of zone availability. </param>
        /// <param name="region"> The cloud service provider region. </param>
        /// <param name="kafkaBootstrapEndpoint"> The bootstrap endpoint used by Kafka clients to connect to the cluster. </param>
        /// <param name="httpEndpoint"> The cluster HTTP request URL. </param>
        /// <param name="apiEndpoint"> The Kafka API cluster endpoint. </param>
        /// <param name="config"> Specification of the cluster. </param>
        /// <param name="environment"> Specification of the cluster. </param>
        /// <param name="network"> Specification of the cluster. </param>
        /// <param name="byok"> Specification of the cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterSpecEntity(string displayName, string availability, string cloud, string zone, string region, string kafkaBootstrapEndpoint, string httpEndpoint, string apiEndpoint, ClusterConfigEntity config, ClusterEnvironmentEntity environment, ClusterNetworkEntity network, ClusterByokEntity byok, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            Availability = availability;
            Cloud = cloud;
            Zone = zone;
            Region = region;
            KafkaBootstrapEndpoint = kafkaBootstrapEndpoint;
            HttpEndpoint = httpEndpoint;
            ApiEndpoint = apiEndpoint;
            Config = config;
            Environment = environment;
            Network = network;
            Byok = byok;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the cluster. </summary>
        public string DisplayName { get; }
        /// <summary> The availability zone configuration of the cluster. </summary>
        public string Availability { get; }
        /// <summary> The cloud service provider. </summary>
        public string Cloud { get; }
        /// <summary> type of zone availability. </summary>
        public string Zone { get; }
        /// <summary> The cloud service provider region. </summary>
        public string Region { get; }
        /// <summary> The bootstrap endpoint used by Kafka clients to connect to the cluster. </summary>
        public string KafkaBootstrapEndpoint { get; }
        /// <summary> The cluster HTTP request URL. </summary>
        public string HttpEndpoint { get; }
        /// <summary> The Kafka API cluster endpoint. </summary>
        public string ApiEndpoint { get; }
        /// <summary> Specification of the cluster. </summary>
        internal ClusterConfigEntity Config { get; }
        /// <summary> The lifecycle phase of the cluster. </summary>
        public string ConfigKind
        {
            get => Config?.Kind;
        }

        /// <summary> Specification of the cluster. </summary>
        public ClusterEnvironmentEntity Environment { get; }
        /// <summary> Specification of the cluster. </summary>
        public ClusterNetworkEntity Network { get; }
        /// <summary> Specification of the cluster. </summary>
        public ClusterByokEntity Byok { get; }
    }
}
