// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Record of the user. </summary>
    public partial class AccessUserRecord
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AccessUserRecord"/>. </summary>
        internal AccessUserRecord()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AccessUserRecord"/>. </summary>
        /// <param name="kind"> Type of account. </param>
        /// <param name="id"> Id of the user. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="email"> Email of the user. </param>
        /// <param name="fullName"> Name of the user. </param>
        /// <param name="authType"> Auth type of the user. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AccessUserRecord(string kind, string id, MetadataEntity metadata, string email, string fullName, string authType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Id = id;
            Metadata = metadata;
            Email = email;
            FullName = fullName;
            AuthType = authType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of account. </summary>
        public string Kind { get; }
        /// <summary> Id of the user. </summary>
        public string Id { get; }
        /// <summary> Metadata of the record. </summary>
        public MetadataEntity Metadata { get; }
        /// <summary> Email of the user. </summary>
        public string Email { get; }
        /// <summary> Name of the user. </summary>
        public string FullName { get; }
        /// <summary> Auth type of the user. </summary>
        public string AuthType { get; }
    }
}
