// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Details on principal, role name and crn pattern of a role binding. </summary>
    public partial class AccessRoleBindingRecord
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AccessRoleBindingRecord"/>. </summary>
        internal AccessRoleBindingRecord()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AccessRoleBindingRecord"/>. </summary>
        /// <param name="kind"> The type of the resource. </param>
        /// <param name="id"> Id of the role binding. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="principal"> The principal User or Group to bind the role to. </param>
        /// <param name="roleName"> The name of the role to bind to the principal. </param>
        /// <param name="crnPattern"> A CRN that specifies the scope and resource patterns necessary for the role to bind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AccessRoleBindingRecord(string kind, string id, MetadataEntity metadata, string principal, string roleName, string crnPattern, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Id = id;
            Metadata = metadata;
            Principal = principal;
            RoleName = roleName;
            CrnPattern = crnPattern;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of the resource. </summary>
        public string Kind { get; }
        /// <summary> Id of the role binding. </summary>
        public string Id { get; }
        /// <summary> Metadata of the record. </summary>
        public MetadataEntity Metadata { get; }
        /// <summary> The principal User or Group to bind the role to. </summary>
        public string Principal { get; }
        /// <summary> The name of the role to bind to the principal. </summary>
        public string RoleName { get; }
        /// <summary> A CRN that specifies the scope and resource patterns necessary for the role to bind. </summary>
        public string CrnPattern { get; }
    }
}
