// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Confluent.Models
{
    public partial class AccessInvitedUserDetails : IUtf8JsonSerializable, IJsonModel<AccessInvitedUserDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AccessInvitedUserDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AccessInvitedUserDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessInvitedUserDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AccessInvitedUserDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(InvitedEmail))
            {
                writer.WritePropertyName("invitedEmail"u8);
                writer.WriteStringValue(InvitedEmail);
            }
            if (Optional.IsDefined(AuthType))
            {
                writer.WritePropertyName("auth_type"u8);
                writer.WriteStringValue(AuthType);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AccessInvitedUserDetails IJsonModel<AccessInvitedUserDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessInvitedUserDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AccessInvitedUserDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAccessInvitedUserDetails(document.RootElement, options);
        }

        internal static AccessInvitedUserDetails DeserializeAccessInvitedUserDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string invitedEmail = default;
            string authType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("invitedEmail"u8))
                {
                    invitedEmail = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("auth_type"u8))
                {
                    authType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AccessInvitedUserDetails(invitedEmail, authType, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AccessInvitedUserDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessInvitedUserDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AccessInvitedUserDetails)} does not support writing '{options.Format}' format.");
            }
        }

        AccessInvitedUserDetails IPersistableModel<AccessInvitedUserDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AccessInvitedUserDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAccessInvitedUserDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AccessInvitedUserDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AccessInvitedUserDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
