// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Record of the invitation. </summary>
    public partial class AccessInvitationRecord
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AccessInvitationRecord"/>. </summary>
        internal AccessInvitationRecord()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AccessInvitationRecord"/>. </summary>
        /// <param name="kind"> Type of account. </param>
        /// <param name="id"> Id of the invitation. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="email"> Email of the user. </param>
        /// <param name="authType"> Auth type of the user. </param>
        /// <param name="status"> Status of the invitation. </param>
        /// <param name="acceptedOn"> Accepted date time of the invitation. </param>
        /// <param name="expireOn"> Expiration date time of the invitation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AccessInvitationRecord(string kind, string id, MetadataEntity metadata, string email, string authType, string status, DateTimeOffset? acceptedOn, DateTimeOffset? expireOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Id = id;
            Metadata = metadata;
            Email = email;
            AuthType = authType;
            Status = status;
            AcceptedOn = acceptedOn;
            ExpireOn = expireOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of account. </summary>
        public string Kind { get; }
        /// <summary> Id of the invitation. </summary>
        public string Id { get; }
        /// <summary> Metadata of the record. </summary>
        public MetadataEntity Metadata { get; }
        /// <summary> Email of the user. </summary>
        public string Email { get; }
        /// <summary> Auth type of the user. </summary>
        public string AuthType { get; }
        /// <summary> Status of the invitation. </summary>
        public string Status { get; }
        /// <summary> Accepted date time of the invitation. </summary>
        public DateTimeOffset? AcceptedOn { get; }
        /// <summary> Expiration date time of the invitation. </summary>
        public DateTimeOffset? ExpireOn { get; }
    }
}
