// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Confluent
{
    internal class ConfluentOrganizationOperationSource : IOperationSource<ConfluentOrganizationResource>
    {
        private readonly ArmClient _client;

        internal ConfluentOrganizationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ConfluentOrganizationResource IOperationSource<ConfluentOrganizationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ConfluentOrganizationData.DeserializeConfluentOrganizationData(document.RootElement);
            return new ConfluentOrganizationResource(_client, data);
        }

        async ValueTask<ConfluentOrganizationResource> IOperationSource<ConfluentOrganizationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ConfluentOrganizationData.DeserializeConfluentOrganizationData(document.RootElement);
            return new ConfluentOrganizationResource(_client, data);
        }
    }
}
