// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Confluent.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableConfluentArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableConfluentArmClient"/> class for mocking. </summary>
        protected MockableConfluentArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableConfluentArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableConfluentArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableConfluentArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConfluentOrganizationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConfluentOrganizationResource.CreateResourceIdentifier" /> to create a <see cref="ConfluentOrganizationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ConfluentOrganizationResource"/> object. </returns>
        public virtual ConfluentOrganizationResource GetConfluentOrganizationResource(ResourceIdentifier id)
        {
            ConfluentOrganizationResource.ValidateResourceId(id);
            return new ConfluentOrganizationResource(Client, id);
        }
    }
}
