// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Confluent.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Confluent
{
    public partial class ConfluentOrganizationData : IUtf8JsonSerializable, IJsonModel<ConfluentOrganizationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConfluentOrganizationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConfluentOrganizationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentOrganizationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConfluentOrganizationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("createdTime"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(OrganizationId))
            {
                writer.WritePropertyName("organizationId"u8);
                writer.WriteStringValue(OrganizationId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SsoUri))
            {
                writer.WritePropertyName("ssoUrl"u8);
                writer.WriteStringValue(SsoUri.AbsoluteUri);
            }
            writer.WritePropertyName("offerDetail"u8);
            writer.WriteObjectValue(OfferDetail, options);
            writer.WritePropertyName("userDetail"u8);
            writer.WriteObjectValue(UserDetail, options);
            if (Optional.IsDefined(LinkOrganization))
            {
                writer.WritePropertyName("linkOrganization"u8);
                writer.WriteObjectValue(LinkOrganization, options);
            }
            writer.WriteEndObject();
        }

        ConfluentOrganizationData IJsonModel<ConfluentOrganizationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentOrganizationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConfluentOrganizationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConfluentOrganizationData(document.RootElement, options);
        }

        internal static ConfluentOrganizationData DeserializeConfluentOrganizationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            DateTimeOffset? createdTime = default;
            ConfluentProvisionState? provisioningState = default;
            Guid? organizationId = default;
            Uri ssoUrl = default;
            ConfluentOfferDetail offerDetail = default;
            ConfluentUserDetail userDetail = default;
            LinkOrganization linkOrganization = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("createdTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            createdTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ConfluentProvisionState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("organizationId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            organizationId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("ssoUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ssoUrl = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("offerDetail"u8))
                        {
                            offerDetail = ConfluentOfferDetail.DeserializeConfluentOfferDetail(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("userDetail"u8))
                        {
                            userDetail = ConfluentUserDetail.DeserializeConfluentUserDetail(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("linkOrganization"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            linkOrganization = LinkOrganization.DeserializeLinkOrganization(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConfluentOrganizationData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                createdTime,
                provisioningState,
                organizationId,
                ssoUrl,
                offerDetail,
                userDetail,
                linkOrganization,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConfluentOrganizationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentOrganizationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConfluentOrganizationData)} does not support writing '{options.Format}' format.");
            }
        }

        ConfluentOrganizationData IPersistableModel<ConfluentOrganizationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfluentOrganizationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConfluentOrganizationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConfluentOrganizationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConfluentOrganizationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
