// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Confluent.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmConfluentModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ConfluentAgreement"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="publisher"> Publisher identifier string. </param>
        /// <param name="product"> Product identifier string. </param>
        /// <param name="plan"> Plan identifier string. </param>
        /// <param name="licenseTextLink"> Link to HTML with Microsoft and Publisher terms. </param>
        /// <param name="privacyPolicyLink"> Link to the privacy policy of the publisher. </param>
        /// <param name="retrieveOn"> Date and time in UTC of when the terms were accepted. This is empty if Accepted is false. </param>
        /// <param name="signature"> Terms signature. </param>
        /// <param name="isAccepted"> If any version of the terms have been accepted, otherwise false. </param>
        /// <returns> A new <see cref="Models.ConfluentAgreement"/> instance for mocking. </returns>
        public static ConfluentAgreement ConfluentAgreement(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string publisher = null, string product = null, string plan = null, string licenseTextLink = null, string privacyPolicyLink = null, DateTimeOffset? retrieveOn = null, string signature = null, bool? isAccepted = null)
        {
            return new ConfluentAgreement(
                id,
                name,
                resourceType,
                systemData,
                publisher,
                product,
                plan,
                licenseTextLink,
                privacyPolicyLink,
                retrieveOn,
                signature,
                isAccepted,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Confluent.ConfluentOrganizationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="createdOn"> The creation time of the resource. </param>
        /// <param name="provisioningState"> Provision states for confluent RP. </param>
        /// <param name="organizationId"> Id of the Confluent organization. </param>
        /// <param name="ssoUri"> SSO url for the Confluent organization. </param>
        /// <param name="offerDetail"> Confluent offer detail. </param>
        /// <param name="userDetail"> Subscriber detail. </param>
        /// <param name="linkOrganizationToken"> Link an existing Confluent organization. </param>
        /// <returns> A new <see cref="Confluent.ConfluentOrganizationData"/> instance for mocking. </returns>
        public static ConfluentOrganizationData ConfluentOrganizationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DateTimeOffset? createdOn = null, ConfluentProvisionState? provisioningState = null, Guid? organizationId = null, Uri ssoUri = null, ConfluentOfferDetail offerDetail = null, ConfluentUserDetail userDetail = null, string linkOrganizationToken = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConfluentOrganizationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                createdOn,
                provisioningState,
                organizationId,
                ssoUri,
                offerDetail,
                userDetail,
                linkOrganizationToken != null ? new LinkOrganization(linkOrganizationToken, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfluentOrganizationValidationResult"/>. </summary>
        /// <param name="info"> Info from the response. </param>
        /// <returns> A new <see cref="Models.ConfluentOrganizationValidationResult"/> instance for mocking. </returns>
        public static ConfluentOrganizationValidationResult ConfluentOrganizationValidationResult(IReadOnlyDictionary<string, string> info = null)
        {
            info ??= new Dictionary<string, string>();

            return new ConfluentOrganizationValidationResult(info, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessUserListResult"/>. </summary>
        /// <param name="kind"> Type of response. </param>
        /// <param name="metadata"> Metadata of the list. </param>
        /// <param name="data"> Data of the users list. </param>
        /// <returns> A new <see cref="Models.AccessUserListResult"/> instance for mocking. </returns>
        public static AccessUserListResult AccessUserListResult(string kind = null, ConfluentListMetadata metadata = null, IEnumerable<AccessUserRecord> data = null)
        {
            data ??= new List<AccessUserRecord>();

            return new AccessUserListResult(kind, metadata, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfluentListMetadata"/>. </summary>
        /// <param name="first"> First page of the list. </param>
        /// <param name="last"> Last page of the list. </param>
        /// <param name="prev"> Previous page of the list. </param>
        /// <param name="next"> Next page of the list. </param>
        /// <param name="totalSize"> Total size of the list. </param>
        /// <returns> A new <see cref="Models.ConfluentListMetadata"/> instance for mocking. </returns>
        public static ConfluentListMetadata ConfluentListMetadata(string first = null, string last = null, string prev = null, string next = null, int? totalSize = null)
        {
            return new ConfluentListMetadata(
                first,
                last,
                prev,
                next,
                totalSize,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessUserRecord"/>. </summary>
        /// <param name="kind"> Type of account. </param>
        /// <param name="id"> Id of the user. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="email"> Email of the user. </param>
        /// <param name="fullName"> Name of the user. </param>
        /// <param name="authType"> Auth type of the user. </param>
        /// <returns> A new <see cref="Models.AccessUserRecord"/> instance for mocking. </returns>
        public static AccessUserRecord AccessUserRecord(string kind = null, string id = null, MetadataEntity metadata = null, string email = null, string fullName = null, string authType = null)
        {
            return new AccessUserRecord(
                kind,
                id,
                metadata,
                email,
                fullName,
                authType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetadataEntity"/>. </summary>
        /// <param name="self"> Self lookup url. </param>
        /// <param name="resourceName"> Resource name of the record. </param>
        /// <param name="createdOn"> Created Date Time. </param>
        /// <param name="updatedOn"> Updated Date time. </param>
        /// <param name="deletedOn"> Deleted Date time. </param>
        /// <returns> A new <see cref="Models.MetadataEntity"/> instance for mocking. </returns>
        public static MetadataEntity MetadataEntity(string self = null, string resourceName = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, DateTimeOffset? deletedOn = null)
        {
            return new MetadataEntity(
                self,
                resourceName,
                createdOn,
                updatedOn,
                deletedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessServiceAccountListResult"/>. </summary>
        /// <param name="kind"> Type of response. </param>
        /// <param name="metadata"> Metadata of the list. </param>
        /// <param name="data"> Data of the service accounts list. </param>
        /// <returns> A new <see cref="Models.AccessServiceAccountListResult"/> instance for mocking. </returns>
        public static AccessServiceAccountListResult AccessServiceAccountListResult(string kind = null, ConfluentListMetadata metadata = null, IEnumerable<AccessServiceAccountRecord> data = null)
        {
            data ??= new List<AccessServiceAccountRecord>();

            return new AccessServiceAccountListResult(kind, metadata, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessServiceAccountRecord"/>. </summary>
        /// <param name="kind"> Type of account. </param>
        /// <param name="id"> Id of the service account. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="displayName"> Name of the service account. </param>
        /// <param name="description"> Description of the service account. </param>
        /// <returns> A new <see cref="Models.AccessServiceAccountRecord"/> instance for mocking. </returns>
        public static AccessServiceAccountRecord AccessServiceAccountRecord(string kind = null, string id = null, MetadataEntity metadata = null, string displayName = null, string description = null)
        {
            return new AccessServiceAccountRecord(
                kind,
                id,
                metadata,
                displayName,
                description,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessInvitationListResult"/>. </summary>
        /// <param name="kind"> Type of response. </param>
        /// <param name="metadata"> Metadata of the list. </param>
        /// <param name="data"> Data of the invitations list. </param>
        /// <returns> A new <see cref="Models.AccessInvitationListResult"/> instance for mocking. </returns>
        public static AccessInvitationListResult AccessInvitationListResult(string kind = null, ConfluentListMetadata metadata = null, IEnumerable<AccessInvitationRecord> data = null)
        {
            data ??= new List<AccessInvitationRecord>();

            return new AccessInvitationListResult(kind, metadata, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessInvitationRecord"/>. </summary>
        /// <param name="kind"> Type of account. </param>
        /// <param name="id"> Id of the invitation. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="email"> Email of the user. </param>
        /// <param name="authType"> Auth type of the user. </param>
        /// <param name="status"> Status of the invitation. </param>
        /// <param name="acceptedOn"> Accepted date time of the invitation. </param>
        /// <param name="expireOn"> Expiration date time of the invitation. </param>
        /// <returns> A new <see cref="Models.AccessInvitationRecord"/> instance for mocking. </returns>
        public static AccessInvitationRecord AccessInvitationRecord(string kind = null, string id = null, MetadataEntity metadata = null, string email = null, string authType = null, string status = null, DateTimeOffset? acceptedOn = null, DateTimeOffset? expireOn = null)
        {
            return new AccessInvitationRecord(
                kind,
                id,
                metadata,
                email,
                authType,
                status,
                acceptedOn,
                expireOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessEnvironmentListResult"/>. </summary>
        /// <param name="kind"> Type of response. </param>
        /// <param name="metadata"> Metadata of the  environment list. </param>
        /// <param name="data"> Environment list data. </param>
        /// <returns> A new <see cref="Models.AccessEnvironmentListResult"/> instance for mocking. </returns>
        public static AccessEnvironmentListResult AccessEnvironmentListResult(string kind = null, ConfluentListMetadata metadata = null, IEnumerable<AccessEnvironmentRecord> data = null)
        {
            data ??= new List<AccessEnvironmentRecord>();

            return new AccessEnvironmentListResult(kind, metadata, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessEnvironmentRecord"/>. </summary>
        /// <param name="kind"> Type of environment. </param>
        /// <param name="id"> Id of the environment. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="displayName"> Display name of the user. </param>
        /// <returns> A new <see cref="Models.AccessEnvironmentRecord"/> instance for mocking. </returns>
        public static AccessEnvironmentRecord AccessEnvironmentRecord(string kind = null, string id = null, MetadataEntity metadata = null, string displayName = null)
        {
            return new AccessEnvironmentRecord(kind, id, metadata, displayName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessClusterListResult"/>. </summary>
        /// <param name="kind"> Type of response. </param>
        /// <param name="metadata"> Metadata of the list. </param>
        /// <param name="data"> List of clusters. </param>
        /// <returns> A new <see cref="Models.AccessClusterListResult"/> instance for mocking. </returns>
        public static AccessClusterListResult AccessClusterListResult(string kind = null, ConfluentListMetadata metadata = null, IEnumerable<AccessClusterRecord> data = null)
        {
            data ??= new List<AccessClusterRecord>();

            return new AccessClusterListResult(kind, metadata, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessClusterRecord"/>. </summary>
        /// <param name="kind"> Type of cluster. </param>
        /// <param name="id"> Id of the cluster. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="displayName"> Display name of the cluster. </param>
        /// <param name="spec"> Specification of the cluster. </param>
        /// <param name="status"> Specification of the cluster. </param>
        /// <returns> A new <see cref="Models.AccessClusterRecord"/> instance for mocking. </returns>
        public static AccessClusterRecord AccessClusterRecord(string kind = null, string id = null, MetadataEntity metadata = null, string displayName = null, ClusterSpecEntity spec = null, ClusterStatusEntity status = null)
        {
            return new AccessClusterRecord(
                kind,
                id,
                metadata,
                displayName,
                spec,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterSpecEntity"/>. </summary>
        /// <param name="displayName"> The name of the cluster. </param>
        /// <param name="availability"> The availability zone configuration of the cluster. </param>
        /// <param name="cloud"> The cloud service provider. </param>
        /// <param name="zone"> type of zone availability. </param>
        /// <param name="region"> The cloud service provider region. </param>
        /// <param name="kafkaBootstrapEndpoint"> The bootstrap endpoint used by Kafka clients to connect to the cluster. </param>
        /// <param name="httpEndpoint"> The cluster HTTP request URL. </param>
        /// <param name="apiEndpoint"> The Kafka API cluster endpoint. </param>
        /// <param name="configKind"> Specification of the cluster. </param>
        /// <param name="environment"> Specification of the cluster. </param>
        /// <param name="network"> Specification of the cluster. </param>
        /// <param name="byok"> Specification of the cluster. </param>
        /// <returns> A new <see cref="Models.ClusterSpecEntity"/> instance for mocking. </returns>
        public static ClusterSpecEntity ClusterSpecEntity(string displayName = null, string availability = null, string cloud = null, string zone = null, string region = null, string kafkaBootstrapEndpoint = null, string httpEndpoint = null, string apiEndpoint = null, string configKind = null, ClusterEnvironmentEntity environment = null, ClusterNetworkEntity network = null, ClusterByokEntity byok = null)
        {
            return new ClusterSpecEntity(
                displayName,
                availability,
                cloud,
                zone,
                region,
                kafkaBootstrapEndpoint,
                httpEndpoint,
                apiEndpoint,
                configKind != null ? new ClusterConfigEntity(configKind, serializedAdditionalRawData: null) : null,
                environment,
                network,
                byok,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterEnvironmentEntity"/>. </summary>
        /// <param name="id"> ID of the referred resource. </param>
        /// <param name="environment"> Environment of the referred resource. </param>
        /// <param name="related"> API URL for accessing or modifying the referred object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <returns> A new <see cref="Models.ClusterEnvironmentEntity"/> instance for mocking. </returns>
        public static ClusterEnvironmentEntity ClusterEnvironmentEntity(string id = null, string environment = null, string related = null, string resourceName = null)
        {
            return new ClusterEnvironmentEntity(id, environment, related, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterNetworkEntity"/>. </summary>
        /// <param name="id"> ID of the referred resource. </param>
        /// <param name="environment"> Environment of the referred resource. </param>
        /// <param name="related"> API URL for accessing or modifying the referred object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <returns> A new <see cref="Models.ClusterNetworkEntity"/> instance for mocking. </returns>
        public static ClusterNetworkEntity ClusterNetworkEntity(string id = null, string environment = null, string related = null, string resourceName = null)
        {
            return new ClusterNetworkEntity(id, environment, related, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterByokEntity"/>. </summary>
        /// <param name="id"> ID of the referred resource. </param>
        /// <param name="related"> API URL for accessing or modifying the referred object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <returns> A new <see cref="Models.ClusterByokEntity"/> instance for mocking. </returns>
        public static ClusterByokEntity ClusterByokEntity(string id = null, string related = null, string resourceName = null)
        {
            return new ClusterByokEntity(id, related, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterStatusEntity"/>. </summary>
        /// <param name="phase"> The lifecycle phase of the cluster. </param>
        /// <param name="cku"> The number of Confluent Kafka Units. </param>
        /// <returns> A new <see cref="Models.ClusterStatusEntity"/> instance for mocking. </returns>
        public static ClusterStatusEntity ClusterStatusEntity(string phase = null, int? cku = null)
        {
            return new ClusterStatusEntity(phase, cku, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessRoleBindingListResult"/>. </summary>
        /// <param name="kind"> Type of response. </param>
        /// <param name="metadata"> Metadata of the list. </param>
        /// <param name="data"> List of role binding. </param>
        /// <returns> A new <see cref="Models.AccessRoleBindingListResult"/> instance for mocking. </returns>
        public static AccessRoleBindingListResult AccessRoleBindingListResult(string kind = null, ConfluentListMetadata metadata = null, IEnumerable<AccessRoleBindingRecord> data = null)
        {
            data ??= new List<AccessRoleBindingRecord>();

            return new AccessRoleBindingListResult(kind, metadata, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessRoleBindingRecord"/>. </summary>
        /// <param name="kind"> The type of the resource. </param>
        /// <param name="id"> Id of the role binding. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="principal"> The principal User or Group to bind the role to. </param>
        /// <param name="roleName"> The name of the role to bind to the principal. </param>
        /// <param name="crnPattern"> A CRN that specifies the scope and resource patterns necessary for the role to bind. </param>
        /// <returns> A new <see cref="Models.AccessRoleBindingRecord"/> instance for mocking. </returns>
        public static AccessRoleBindingRecord AccessRoleBindingRecord(string kind = null, string id = null, MetadataEntity metadata = null, string principal = null, string roleName = null, string crnPattern = null)
        {
            return new AccessRoleBindingRecord(
                kind,
                id,
                metadata,
                principal,
                roleName,
                crnPattern,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccessRoleBindingNameListResult"/>. </summary>
        /// <param name="kind"> Type of response. </param>
        /// <param name="metadata"> Metadata of the list. </param>
        /// <param name="data"> List of role binding names. </param>
        /// <returns> A new <see cref="Models.AccessRoleBindingNameListResult"/> instance for mocking. </returns>
        public static AccessRoleBindingNameListResult AccessRoleBindingNameListResult(string kind = null, ConfluentListMetadata metadata = null, IEnumerable<string> data = null)
        {
            data ??= new List<string>();

            return new AccessRoleBindingNameListResult(kind, metadata, data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SCEnvironmentRecord"/>. </summary>
        /// <param name="kind"> Type of environment. </param>
        /// <param name="id"> Id of the environment. </param>
        /// <param name="name"> Display name of the environment. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <returns> A new <see cref="Models.SCEnvironmentRecord"/> instance for mocking. </returns>
        public static SCEnvironmentRecord SCEnvironmentRecord(string kind = null, string id = null, string name = null, SCMetadataEntity metadata = null)
        {
            return new SCEnvironmentRecord(kind, id, name, metadata, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SCMetadataEntity"/>. </summary>
        /// <param name="self"> Self lookup url. </param>
        /// <param name="resourceName"> Resource name of the record. </param>
        /// <param name="createdOn"> Created Date Time. </param>
        /// <param name="updatedOn"> Updated Date time. </param>
        /// <param name="deletedOn"> Deleted Date time. </param>
        /// <returns> A new <see cref="Models.SCMetadataEntity"/> instance for mocking. </returns>
        public static SCMetadataEntity SCMetadataEntity(string self = null, string resourceName = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, DateTimeOffset? deletedOn = null)
        {
            return new SCMetadataEntity(
                self,
                resourceName,
                createdOn,
                updatedOn,
                deletedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SCClusterRecord"/>. </summary>
        /// <param name="kind"> Type of cluster. </param>
        /// <param name="id"> Id of the cluster. </param>
        /// <param name="name"> Display name of the cluster. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="spec"> Specification of the cluster. </param>
        /// <param name="status"> Specification of the cluster status. </param>
        /// <returns> A new <see cref="Models.SCClusterRecord"/> instance for mocking. </returns>
        public static SCClusterRecord SCClusterRecord(string kind = null, string id = null, string name = null, SCMetadataEntity metadata = null, SCClusterSpecEntity spec = null, ClusterStatusEntity status = null)
        {
            return new SCClusterRecord(
                kind,
                id,
                name,
                metadata,
                spec,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SCClusterSpecEntity"/>. </summary>
        /// <param name="name"> The name of the cluster. </param>
        /// <param name="availability"> The availability zone configuration of the cluster. </param>
        /// <param name="cloud"> The cloud service provider. </param>
        /// <param name="zone"> type of zone availability. </param>
        /// <param name="region"> The cloud service provider region. </param>
        /// <param name="kafkaBootstrapEndpoint"> The bootstrap endpoint used by Kafka clients to connect to the cluster. </param>
        /// <param name="httpEndpoint"> The cluster HTTP request URL. </param>
        /// <param name="apiEndpoint"> The Kafka API cluster endpoint. </param>
        /// <param name="configKind"> Specification of the cluster configuration. </param>
        /// <param name="environment"> Specification of the cluster environment. </param>
        /// <param name="network"> Specification of the cluster network. </param>
        /// <param name="byok"> Specification of the cluster byok. </param>
        /// <returns> A new <see cref="Models.SCClusterSpecEntity"/> instance for mocking. </returns>
        public static SCClusterSpecEntity SCClusterSpecEntity(string name = null, string availability = null, string cloud = null, string zone = null, string region = null, string kafkaBootstrapEndpoint = null, string httpEndpoint = null, string apiEndpoint = null, string configKind = null, SCClusterNetworkEnvironmentEntity environment = null, SCClusterNetworkEnvironmentEntity network = null, SCClusterByokEntity byok = null)
        {
            return new SCClusterSpecEntity(
                name,
                availability,
                cloud,
                zone,
                region,
                kafkaBootstrapEndpoint,
                httpEndpoint,
                apiEndpoint,
                configKind != null ? new ClusterConfigEntity(configKind, serializedAdditionalRawData: null) : null,
                environment,
                network,
                byok,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SCClusterNetworkEnvironmentEntity"/>. </summary>
        /// <param name="id"> ID of the referred resource. </param>
        /// <param name="environment"> Environment of the referred resource. </param>
        /// <param name="related"> API URL for accessing or modifying the referred object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <returns> A new <see cref="Models.SCClusterNetworkEnvironmentEntity"/> instance for mocking. </returns>
        public static SCClusterNetworkEnvironmentEntity SCClusterNetworkEnvironmentEntity(string id = null, string environment = null, string related = null, string resourceName = null)
        {
            return new SCClusterNetworkEnvironmentEntity(id, environment, related, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SCClusterByokEntity"/>. </summary>
        /// <param name="id"> ID of the referred resource. </param>
        /// <param name="related"> API URL for accessing or modifying the referred object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <returns> A new <see cref="Models.SCClusterByokEntity"/> instance for mocking. </returns>
        public static SCClusterByokEntity SCClusterByokEntity(string id = null, string related = null, string resourceName = null)
        {
            return new SCClusterByokEntity(id, related, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SchemaRegistryClusterRecord"/>. </summary>
        /// <param name="kind"> Kind of the cluster. </param>
        /// <param name="id"> Id of the cluster. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="spec"> Specification of the schema registry cluster. </param>
        /// <param name="statusPhase"> Specification of the cluster status. </param>
        /// <returns> A new <see cref="Models.SchemaRegistryClusterRecord"/> instance for mocking. </returns>
        public static SchemaRegistryClusterRecord SchemaRegistryClusterRecord(string kind = null, string id = null, SCMetadataEntity metadata = null, SchemaRegistryClusterSpecEntity spec = null, string statusPhase = null)
        {
            return new SchemaRegistryClusterRecord(
                kind,
                id,
                metadata,
                spec,
                statusPhase != null ? new SchemaRegistryClusterStatusEntity(statusPhase, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SchemaRegistryClusterSpecEntity"/>. </summary>
        /// <param name="name"> Name of the schema registry cluster. </param>
        /// <param name="httpEndpoint"> Http endpoint of the cluster. </param>
        /// <param name="package"> Type of the cluster package Advanced, essentials. </param>
        /// <param name="region"> Region details of the schema registry cluster. </param>
        /// <param name="environment"> Environment details of the schema registry cluster. </param>
        /// <param name="cloud"> The cloud service provider. </param>
        /// <returns> A new <see cref="Models.SchemaRegistryClusterSpecEntity"/> instance for mocking. </returns>
        public static SchemaRegistryClusterSpecEntity SchemaRegistryClusterSpecEntity(string name = null, string httpEndpoint = null, string package = null, SchemaRegistryClusterEnvironmentRegionEntity region = null, SchemaRegistryClusterEnvironmentRegionEntity environment = null, string cloud = null)
        {
            return new SchemaRegistryClusterSpecEntity(
                name,
                httpEndpoint,
                package,
                region,
                environment,
                cloud,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SchemaRegistryClusterEnvironmentRegionEntity"/>. </summary>
        /// <param name="id"> ID of the referred resource. </param>
        /// <param name="related"> API URL for accessing or modifying the referred object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <returns> A new <see cref="Models.SchemaRegistryClusterEnvironmentRegionEntity"/> instance for mocking. </returns>
        public static SchemaRegistryClusterEnvironmentRegionEntity SchemaRegistryClusterEnvironmentRegionEntity(string id = null, string related = null, string resourceName = null)
        {
            return new SchemaRegistryClusterEnvironmentRegionEntity(id, related, resourceName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfluentRegionListResult"/>. </summary>
        /// <param name="data"> List of regions supported by confluent. </param>
        /// <returns> A new <see cref="Models.ConfluentRegionListResult"/> instance for mocking. </returns>
        public static ConfluentRegionListResult ConfluentRegionListResult(IEnumerable<ConfluentRegionRecord> data = null)
        {
            data ??= new List<ConfluentRegionRecord>();

            return new ConfluentRegionListResult(data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfluentRegionRecord"/>. </summary>
        /// <param name="kind"> Kind of the cluster. </param>
        /// <param name="id"> Id of the cluster. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="spec"> Specification of the region. </param>
        /// <returns> A new <see cref="Models.ConfluentRegionRecord"/> instance for mocking. </returns>
        public static ConfluentRegionRecord ConfluentRegionRecord(string kind = null, string id = null, SCMetadataEntity metadata = null, RegionSpecEntity spec = null)
        {
            return new ConfluentRegionRecord(kind, id, metadata, spec, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RegionSpecEntity"/>. </summary>
        /// <param name="name"> Display Name of the region. </param>
        /// <param name="cloud"> Cloud provider name. </param>
        /// <param name="regionName"> Region name. </param>
        /// <param name="packages"></param>
        /// <returns> A new <see cref="Models.RegionSpecEntity"/> instance for mocking. </returns>
        public static RegionSpecEntity RegionSpecEntity(string name = null, string cloud = null, string regionName = null, IEnumerable<string> packages = null)
        {
            packages ??= new List<string>();

            return new RegionSpecEntity(name, cloud, regionName, packages?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfluentApiKeyRecord"/>. </summary>
        /// <param name="kind"> Type of api key. </param>
        /// <param name="id"> Id of the api key. </param>
        /// <param name="metadata"> Metadata of the record. </param>
        /// <param name="spec"> Specification of the API Key. </param>
        /// <returns> A new <see cref="Models.ConfluentApiKeyRecord"/> instance for mocking. </returns>
        public static ConfluentApiKeyRecord ConfluentApiKeyRecord(string kind = null, string id = null, SCMetadataEntity metadata = null, ApiKeySpecEntity spec = null)
        {
            return new ConfluentApiKeyRecord(kind, id, metadata, spec, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApiKeySpecEntity"/>. </summary>
        /// <param name="description"> The description of the API Key. </param>
        /// <param name="name"> The name of the API Key. </param>
        /// <param name="secret"> API Key Secret. </param>
        /// <param name="resource"> Specification of the cluster. </param>
        /// <param name="owner"> Specification of the cluster. </param>
        /// <returns> A new <see cref="Models.ApiKeySpecEntity"/> instance for mocking. </returns>
        public static ApiKeySpecEntity ApiKeySpecEntity(string description = null, string name = null, string secret = null, ApiKeyResourceEntity resource = null, ApiKeyOwnerEntity owner = null)
        {
            return new ApiKeySpecEntity(
                description,
                name,
                secret,
                resource,
                owner,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApiKeyResourceEntity"/>. </summary>
        /// <param name="id"> Id of the resource. </param>
        /// <param name="environment"> The environment of the api key. </param>
        /// <param name="related"> API URL for accessing or modifying the api key resource object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <param name="kind"> Type of the owner which can be service or user account. </param>
        /// <returns> A new <see cref="Models.ApiKeyResourceEntity"/> instance for mocking. </returns>
        public static ApiKeyResourceEntity ApiKeyResourceEntity(string id = null, string environment = null, string related = null, string resourceName = null, string kind = null)
        {
            return new ApiKeyResourceEntity(
                id,
                environment,
                related,
                resourceName,
                kind,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApiKeyOwnerEntity"/>. </summary>
        /// <param name="id"> API Key owner id. </param>
        /// <param name="related"> API URL for accessing or modifying the referred object. </param>
        /// <param name="resourceName"> CRN reference to the referred resource. </param>
        /// <param name="kind"> Type of the owner service or user account. </param>
        /// <returns> A new <see cref="Models.ApiKeyOwnerEntity"/> instance for mocking. </returns>
        public static ApiKeyOwnerEntity ApiKeyOwnerEntity(string id = null, string related = null, string resourceName = null, string kind = null)
        {
            return new ApiKeyOwnerEntity(id, related, resourceName, kind, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of ConfluentOrganizationData. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="createdOn"> The creation time of the resource. </param>
        /// <param name="provisioningState"> Provision states for confluent RP. </param>
        /// <param name="organizationId"> Id of the Confluent organization. </param>
        /// <param name="ssoUri"> SSO url for the Confluent organization. </param>
        /// <param name="offerDetail"> Confluent offer detail. </param>
        /// <param name="userDetail"> Subscriber detail. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Confluent.ConfluentOrganizationData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ConfluentOrganizationData ConfluentOrganizationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, DateTimeOffset? createdOn, ConfluentProvisionState? provisioningState, Guid? organizationId, Uri ssoUri, ConfluentOfferDetail offerDetail, ConfluentUserDetail userDetail)
        {
            return ConfluentOrganizationData(id: id, name: name, resourceType: resourceType, systemData: systemData, tags: tags, location: location, createdOn: createdOn, provisioningState: provisioningState, organizationId: organizationId, ssoUri: ssoUri, offerDetail: offerDetail, userDetail: userDetail, linkOrganizationToken: default);
        }
    }
}
