// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Confluent.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Confluent.Samples
{
    public partial class Sample_ConfluentOrganizationResource
    {
        // Organization_ListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetConfluentOrganizations_OrganizationListBySubscription()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_ListBySubscription.json
            // this example is just showing the usage of "Organization_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (ConfluentOrganizationResource item in subscriptionResource.GetConfluentOrganizationsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ConfluentOrganizationData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Organization_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_OrganizationGet()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_Get.json
            // this example is just showing the usage of "Organization_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            ConfluentOrganizationResource result = await confluentOrganization.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConfluentOrganizationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Confluent_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ConfluentUpdate()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_Update.json
            // this example is just showing the usage of "Organization_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            ConfluentOrganizationPatch patch = new ConfluentOrganizationPatch()
            {
                Tags =
{
["client"] = "dev-client",
["env"] = "dev",
},
            };
            ConfluentOrganizationResource result = await confluentOrganization.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConfluentOrganizationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Confluent_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ConfluentDelete()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_Delete.json
            // this example is just showing the usage of "Organization_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            await confluentOrganization.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Organization_ListEnvironments
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEnvironments_OrganizationListEnvironments()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_EnvironmentList.json
            // this example is just showing the usage of "Organization_ListEnvironments" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation and iterate over the result
            int? pageSize = 10;
            await foreach (SCEnvironmentRecord item in confluentOrganization.GetEnvironmentsAsync(pageSize: pageSize))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Organization_GetEnvironmentById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEnvironment_OrganizationGetEnvironmentById()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_GetEnvironmentById.json
            // this example is just showing the usage of "Organization_GetEnvironmentById" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            string environmentId = "dlz-f3a90de";
            SCEnvironmentRecord result = await confluentOrganization.GetEnvironmentAsync(environmentId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Organization_ListClusters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusters_OrganizationListClusters()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_ClusterList.json
            // this example is just showing the usage of "Organization_ListClusters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation and iterate over the result
            string environmentId = "env-12132";
            int? pageSize = 10;
            await foreach (SCClusterRecord item in confluentOrganization.GetClustersAsync(environmentId, pageSize: pageSize))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Organization_ListSchemaRegistryClusters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSchemaRegistryClusters_OrganizationListSchemaRegistryClusters()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_ListSchemaRegistryClusters.json
            // this example is just showing the usage of "Organization_ListSchemaRegistryClusters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation and iterate over the result
            string environmentId = "env-stgcczjp2j3";
            await foreach (SchemaRegistryClusterRecord item in confluentOrganization.GetSchemaRegistryClustersAsync(environmentId))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Organization_ListRegions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRegions_OrganizationListRegions()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_ListRegions.json
            // this example is just showing the usage of "Organization_ListRegions" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["cloud"] = "azure",
["packages"] = "ADVANCED,ESSENTIALS",
["region"] = "eastus",
},
            };
            ConfluentRegionListResult result = await confluentOrganization.GetRegionsAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Organization_CreateAPIKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateApiKey_OrganizationCreateAPIKey()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_CreateClusterAPIKey.json
            // this example is just showing the usage of "Organization_CreateApiKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            string environmentId = "env-12132";
            string clusterId = "clusterId-123";
            ConfluentApiKeyCreateContent content = new ConfluentApiKeyCreateContent()
            {
                Name = "CI kafka access key",
                Description = "This API key provides kafka access to cluster x",
            };
            ConfluentApiKeyRecord result = await confluentOrganization.CreateApiKeyAsync(environmentId, clusterId, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Organization_DeleteClusterAPIKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteClusterApiKey_OrganizationDeleteClusterAPIKey()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_DeleteClusterAPIKey.json
            // this example is just showing the usage of "Organization_DeleteClusterApiKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            string apiKeyId = "ZFZ6SZZZWGYBEIFB";
            await confluentOrganization.DeleteClusterApiKeyAsync(apiKeyId);

            Console.WriteLine($"Succeeded");
        }

        // Organization_GetClusterAPIKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusterApiKey_OrganizationGetClusterAPIKey()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_GetClusterAPIKey.json
            // this example is just showing the usage of "Organization_GetClusterApiKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            string apiKeyId = "apiKeyId-123";
            ConfluentApiKeyRecord result = await confluentOrganization.GetClusterApiKeyAsync(apiKeyId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Organization_GetSchemaRegistryClusterById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSchemaRegistryCluster_OrganizationGetSchemaRegistryClusterById()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_GetSchemaRegistryClusterById.json
            // this example is just showing the usage of "Organization_GetSchemaRegistryClusterById" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            string environmentId = "env-stgcczjp2j3";
            string clusterId = "lsrc-stgczkq22z";
            SchemaRegistryClusterRecord result = await confluentOrganization.GetSchemaRegistryClusterAsync(environmentId, clusterId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Organization_GetClusterById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetCluster_OrganizationGetClusterById()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Organization_GetClusterById.json
            // this example is just showing the usage of "Organization_GetClusterById" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            string environmentId = "env-12132";
            string clusterId = "dlz-f3a90de";
            SCClusterRecord result = await confluentOrganization.GetClusterAsync(environmentId, clusterId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_UsersList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAccessUsers_AccessUsersList()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_UsersList.json
            // this example is just showing the usage of "Access_ListUsers" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["pageSize"] = "10",
["pageToken"] = "asc4fts4ft",
},
            };
            AccessUserListResult result = await confluentOrganization.GetAccessUsersAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_ServiceAccountsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAccessServiceAccounts_AccessServiceAccountsList()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_ServiceAccountsList.json
            // this example is just showing the usage of "Access_ListServiceAccounts" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["pageSize"] = "10",
["pageToken"] = "asc4fts4ft",
},
            };
            AccessServiceAccountListResult result = await confluentOrganization.GetAccessServiceAccountsAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_InvitationsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAccessInvitations_AccessInvitationsList()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_InvitationsList.json
            // this example is just showing the usage of "Access_ListInvitations" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["pageSize"] = "10",
["pageToken"] = "asc4fts4ft",
["status"] = "INVITE_STATUS_SENT",
},
            };
            AccessInvitationListResult result = await confluentOrganization.GetAccessInvitationsAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_InviteUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task InviteUser_AccessInviteUser()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_InviteUser.json
            // this example is just showing the usage of "Access_InviteUser" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessInvitationContent content = new AccessInvitationContent()
            {
                InvitedUserDetails = new AccessInvitedUserDetails()
                {
                    InvitedEmail = "user2@onmicrosoft.com",
                    AuthType = "AUTH_TYPE_SSO",
                },
            };
            AccessInvitationRecord result = await confluentOrganization.InviteUserAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_EnvironmentList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAccessEnvironments_AccessEnvironmentList()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_EnvironmentList.json
            // this example is just showing the usage of "Access_ListEnvironments" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["pageSize"] = "10",
["pageToken"] = "asc4fts4ft",
},
            };
            AccessEnvironmentListResult result = await confluentOrganization.GetAccessEnvironmentsAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_ClusterList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAccessClusters_AccessClusterList()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_ClusterList.json
            // this example is just showing the usage of "Access_ListClusters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["pageSize"] = "10",
["pageToken"] = "asc4fts4ft",
},
            };
            AccessClusterListResult result = await confluentOrganization.GetAccessClustersAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_RoleBindingList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAccessRoleBindings_AccessRoleBindingList()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_RoleBindingList.json
            // this example is just showing the usage of "Access_ListRoleBindings" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["pageSize"] = "10",
["pageToken"] = "asc4fts4ft",
},
            };
            AccessRoleBindingListResult result = await confluentOrganization.GetAccessRoleBindingsAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_CreateRoleBinding
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateAccessRoleBinding_AccessCreateRoleBinding()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_CreateRoleBinding.json
            // this example is just showing the usage of "Access_CreateRoleBinding" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessRoleBindingCreateContent content = new AccessRoleBindingCreateContent()
            {
                Principal = "User:u-111aaa",
                RoleName = "CloudClusterAdmin",
                CrnPattern = "crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa/environment=env-aaa1111/cloud-cluster=lkc-1111aaa",
            };
            AccessRoleBindingRecord result = await confluentOrganization.CreateAccessRoleBindingAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Access_DeleteRoleBinding
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteAccessRoleBinding_AccessDeleteRoleBinding()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_DeleteRoleBinding.json
            // this example is just showing the usage of "Access_DeleteRoleBinding" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            string roleBindingId = "dlz-f3a90de";
            await confluentOrganization.DeleteAccessRoleBindingAsync(roleBindingId);

            Console.WriteLine($"Succeeded");
        }

        // Access_RoleBindingNameList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAccessRoleBindingNames_AccessRoleBindingNameList()
        {
            // Generated from example definition: specification/confluent/resource-manager/Microsoft.Confluent/stable/2024-02-13/examples/Access_RoleBindingNameList.json
            // this example is just showing the usage of "Access_ListRoleBindingNameList" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConfluentOrganizationResource created on azure
            // for more information of creating ConfluentOrganizationResource, please refer to the document of ConfluentOrganizationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string organizationName = "myOrganization";
            ResourceIdentifier confluentOrganizationResourceId = ConfluentOrganizationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, organizationName);
            ConfluentOrganizationResource confluentOrganization = client.GetConfluentOrganizationResource(confluentOrganizationResourceId);

            // invoke the operation
            AccessListContent content = new AccessListContent()
            {
                SearchFilters =
{
["crn_pattern"] = "crn://confluent.cloud/organization=1aa7de07-298e-479c-8f2f-16ac91fd8e76",
["namespace"] = "public,dataplane,networking,identity,datagovernance,connect,streamcatalog,pipelines,ksql",
},
            };
            AccessRoleBindingNameListResult result = await confluentOrganization.GetAccessRoleBindingNamesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
