// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Security.ConfidentialLedger.Samples
{
    public partial class Samples_ConfidentialLedgerClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetConstitution_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetConstitution();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("digest").ToString());
            Console.WriteLine(result.GetProperty("script").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetConstitution_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetConstitutionAsync();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("digest").ToString());
            Console.WriteLine(result.GetProperty("script").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetConstitution_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetConstitution();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("digest").ToString());
            Console.WriteLine(result.GetProperty("script").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetConstitution_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetConstitutionAsync();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("digest").ToString());
            Console.WriteLine(result.GetProperty("script").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEnclaveQuotes_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetEnclaveQuotes();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("currentNodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("nodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("quoteVersion").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("raw").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEnclaveQuotes_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetEnclaveQuotesAsync();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("currentNodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("nodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("quoteVersion").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("raw").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetEnclaveQuotes_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetEnclaveQuotes();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("currentNodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("nodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("mrenclave").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("quoteVersion").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("raw").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetEnclaveQuotes_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetEnclaveQuotesAsync();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("currentNodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("nodeId").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("mrenclave").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("quoteVersion").ToString());
            Console.WriteLine(result.GetProperty("enclaveQuotes").GetProperty("<key>").GetProperty("raw").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateLedgerEntry_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                contents = "<contents>",
            });
            Response response = client.CreateLedgerEntry(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("collectionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateLedgerEntry_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                contents = "<contents>",
            });
            Response response = await client.CreateLedgerEntryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("collectionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateLedgerEntry_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                contents = "<contents>",
            });
            Response response = client.CreateLedgerEntry(content, collectionId: "<collectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("collectionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateLedgerEntry_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                contents = "<contents>",
            });
            Response response = await client.CreateLedgerEntryAsync(content, collectionId: "<collectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("collectionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLedgerEntry_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetLedgerEntry("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLedgerEntry_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetLedgerEntryAsync("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLedgerEntry_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetLedgerEntry("<transactionId>", collectionId: "<collectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("entry").GetProperty("contents").ToString());
            Console.WriteLine(result.GetProperty("entry").GetProperty("collectionId").ToString());
            Console.WriteLine(result.GetProperty("entry").GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLedgerEntry_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetLedgerEntryAsync("<transactionId>", collectionId: "<collectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("entry").GetProperty("contents").ToString());
            Console.WriteLine(result.GetProperty("entry").GetProperty("collectionId").ToString());
            Console.WriteLine(result.GetProperty("entry").GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetReceipt_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetReceipt("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetReceipt_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetReceiptAsync("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetReceipt_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetReceipt("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("receipt").GetProperty("cert").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leaf").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leafComponents").GetProperty("claimsDigest").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leafComponents").GetProperty("commitEvidence").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leafComponents").GetProperty("writeSetDigest").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("nodeId").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("proof")[0].GetProperty("left").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("proof")[0].GetProperty("right").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("root").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("serviceEndorsements")[0].ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("signature").ToString());
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetReceipt_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetReceiptAsync("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("receipt").GetProperty("cert").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leaf").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leafComponents").GetProperty("claimsDigest").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leafComponents").GetProperty("commitEvidence").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("leafComponents").GetProperty("writeSetDigest").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("nodeId").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("proof")[0].GetProperty("left").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("proof")[0].GetProperty("right").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("root").ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("serviceEndorsements")[0].ToString());
            Console.WriteLine(result.GetProperty("receipt").GetProperty("signature").ToString());
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTransactionStatus_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetTransactionStatus("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTransactionStatus_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetTransactionStatusAsync("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetTransactionStatus_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetTransactionStatus("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetTransactionStatus_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetTransactionStatusAsync("<transactionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("state").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCurrentLedgerEntry_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetCurrentLedgerEntry();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("contents").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCurrentLedgerEntry_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetCurrentLedgerEntryAsync();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("contents").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCurrentLedgerEntry_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetCurrentLedgerEntry(collectionId: "<collectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("contents").ToString());
            Console.WriteLine(result.GetProperty("collectionId").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCurrentLedgerEntry_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetCurrentLedgerEntryAsync(collectionId: "<collectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("contents").ToString());
            Console.WriteLine(result.GetProperty("collectionId").ToString());
            Console.WriteLine(result.GetProperty("transactionId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteUser_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.DeleteUser("<userId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteUser_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.DeleteUserAsync("<userId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteUser_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.DeleteUser("<userId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteUser_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.DeleteUserAsync("<userId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUser_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetUser("<userId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUser_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetUserAsync("<userId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUser_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = client.GetUser("<userId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
            Console.WriteLine(result.GetProperty("userId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUser_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            Response response = await client.GetUserAsync("<userId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
            Console.WriteLine(result.GetProperty("userId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdateUser_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                assignedRole = "Administrator",
            });
            Response response = client.CreateOrUpdateUser("<userId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdateUser_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                assignedRole = "Administrator",
            });
            Response response = await client.CreateOrUpdateUserAsync("<userId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdateUser_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                assignedRole = "Administrator",
            });
            Response response = client.CreateOrUpdateUser("<userId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
            Console.WriteLine(result.GetProperty("userId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdateUser_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            using RequestContent content = RequestContent.Create(new
            {
                assignedRole = "Administrator",
            });
            Response response = await client.CreateOrUpdateUserAsync("<userId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("assignedRole").ToString());
            Console.WriteLine(result.GetProperty("userId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetConsortiumMembers_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            foreach (BinaryData item in client.GetConsortiumMembers())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("certificate").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetConsortiumMembers_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            await foreach (BinaryData item in client.GetConsortiumMembersAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("certificate").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetConsortiumMembers_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            foreach (BinaryData item in client.GetConsortiumMembers())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("certificate").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetConsortiumMembers_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            await foreach (BinaryData item in client.GetConsortiumMembersAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("certificate").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCollections_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            foreach (BinaryData item in client.GetCollections())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("collectionId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCollections_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            await foreach (BinaryData item in client.GetCollectionsAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("collectionId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetCollections_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            foreach (BinaryData item in client.GetCollections())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("collectionId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetCollections_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            await foreach (BinaryData item in client.GetCollectionsAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("collectionId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLedgerEntries_ShortVersion()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            foreach (BinaryData item in client.GetLedgerEntries())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("contents").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLedgerEntries_ShortVersion_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            await foreach (BinaryData item in client.GetLedgerEntriesAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("contents").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLedgerEntries_AllParameters()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            foreach (BinaryData item in client.GetLedgerEntries(collectionId: "<collectionId>", fromTransactionId: "<fromTransactionId>", toTransactionId: "<toTransactionId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("contents").ToString());
                Console.WriteLine(result.GetProperty("collectionId").ToString());
                Console.WriteLine(result.GetProperty("transactionId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLedgerEntries_AllParameters_Async()
        {
            TokenCredential credential = new DefaultAzureCredential();
            ConfidentialLedgerClient client = new ConfidentialLedgerClient(new Uri("http://localhost:3000"), credential);

            await foreach (BinaryData item in client.GetLedgerEntriesAsync(collectionId: "<collectionId>", fromTransactionId: "<fromTransactionId>", toTransactionId: "<toTransactionId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("contents").ToString());
                Console.WriteLine(result.GetProperty("collectionId").ToString());
                Console.WriteLine(result.GetProperty("transactionId").ToString());
            }
        }
    }
}
