// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Security.CodeTransparency
{
    /// <summary> The Response body of the Version API. </summary>
    public partial class VersionResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VersionResult"/>. </summary>
        /// <param name="scittVersion"> Version of the CodeTransparency service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scittVersion"/> is null. </exception>
        internal VersionResult(string scittVersion)
        {
            Argument.AssertNotNull(scittVersion, nameof(scittVersion));

            ScittVersion = scittVersion;
        }

        /// <summary> Initializes a new instance of <see cref="VersionResult"/>. </summary>
        /// <param name="scittVersion"> Version of the CodeTransparency service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VersionResult(string scittVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ScittVersion = scittVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="VersionResult"/> for deserialization. </summary>
        internal VersionResult()
        {
        }

        /// <summary> Version of the CodeTransparency service. </summary>
        public string ScittVersion { get; }
    }
}
