// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Security.CodeTransparency
{
    /// <summary> The Response body of the service parameters. </summary>
    public partial class ParametersResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ParametersResult"/>. </summary>
        /// <param name="serviceCertificate"></param>
        /// <param name="serviceId"></param>
        /// <param name="signatureAlgorithm"></param>
        /// <param name="treeAlgorithm"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceCertificate"/>, <paramref name="serviceId"/>, <paramref name="signatureAlgorithm"/> or <paramref name="treeAlgorithm"/> is null. </exception>
        internal ParametersResult(string serviceCertificate, string serviceId, string signatureAlgorithm, string treeAlgorithm)
        {
            Argument.AssertNotNull(serviceCertificate, nameof(serviceCertificate));
            Argument.AssertNotNull(serviceId, nameof(serviceId));
            Argument.AssertNotNull(signatureAlgorithm, nameof(signatureAlgorithm));
            Argument.AssertNotNull(treeAlgorithm, nameof(treeAlgorithm));

            ServiceCertificate = serviceCertificate;
            ServiceId = serviceId;
            SignatureAlgorithm = signatureAlgorithm;
            TreeAlgorithm = treeAlgorithm;
        }

        /// <summary> Initializes a new instance of <see cref="ParametersResult"/>. </summary>
        /// <param name="serviceCertificate"></param>
        /// <param name="serviceId"></param>
        /// <param name="signatureAlgorithm"></param>
        /// <param name="treeAlgorithm"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ParametersResult(string serviceCertificate, string serviceId, string signatureAlgorithm, string treeAlgorithm, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceCertificate = serviceCertificate;
            ServiceId = serviceId;
            SignatureAlgorithm = signatureAlgorithm;
            TreeAlgorithm = treeAlgorithm;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ParametersResult"/> for deserialization. </summary>
        internal ParametersResult()
        {
        }

        /// <summary> Gets the service certificate. </summary>
        public string ServiceCertificate { get; }
        /// <summary> Gets the service id. </summary>
        public string ServiceId { get; }
        /// <summary> Gets the signature algorithm. </summary>
        public string SignatureAlgorithm { get; }
        /// <summary> Gets the tree algorithm. </summary>
        public string TreeAlgorithm { get; }
    }
}
