// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Security.CodeTransparency
{
    /// <summary> The Response body of the ListOperations API. </summary>
    public partial class ListOperationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ListOperationResult"/>. </summary>
        /// <param name="operations"> List of operations. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operations"/> is null. </exception>
        internal ListOperationResult(IEnumerable<GetOperationResult> operations)
        {
            Argument.AssertNotNull(operations, nameof(operations));

            Operations = operations.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ListOperationResult"/>. </summary>
        /// <param name="operations"> List of operations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ListOperationResult(IReadOnlyList<GetOperationResult> operations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Operations = operations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ListOperationResult"/> for deserialization. </summary>
        internal ListOperationResult()
        {
        }

        /// <summary> List of operations. </summary>
        public IReadOnlyList<GetOperationResult> Operations { get; }
    }
}
