// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Security.CodeTransparency
{
    /// <summary> The DidDocumentKey_type. </summary>
    public readonly partial struct DidDocumentKeyType : IEquatable<DidDocumentKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DidDocumentKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DidDocumentKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JsonWebKey2020Value = "JsonWebKey2020";

        /// <summary> JsonWebKey2020. </summary>
        public static DidDocumentKeyType JsonWebKey2020 { get; } = new DidDocumentKeyType(JsonWebKey2020Value);
        /// <summary> Determines if two <see cref="DidDocumentKeyType"/> values are the same. </summary>
        public static bool operator ==(DidDocumentKeyType left, DidDocumentKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DidDocumentKeyType"/> values are not the same. </summary>
        public static bool operator !=(DidDocumentKeyType left, DidDocumentKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DidDocumentKeyType"/>. </summary>
        public static implicit operator DidDocumentKeyType(string value) => new DidDocumentKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DidDocumentKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DidDocumentKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
