// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Security.CodeTransparency
{
    /// <summary> A DID document key. </summary>
    public partial class DidDocumentKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DidDocumentKey"/>. </summary>
        /// <param name="id"> Key identifier. </param>
        /// <param name="controller"> Key controller - similar to DID issuer. </param>
        /// <param name="publicKeyJwk"> Serialized public key in JWK format. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="controller"/> or <paramref name="publicKeyJwk"/> is null. </exception>
        internal DidDocumentKey(string id, string controller, JsonWebKey publicKeyJwk)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(controller, nameof(controller));
            Argument.AssertNotNull(publicKeyJwk, nameof(publicKeyJwk));

            Id = id;
            Controller = controller;
            PublicKeyJwk = publicKeyJwk;
        }

        /// <summary> Initializes a new instance of <see cref="DidDocumentKey"/>. </summary>
        /// <param name="id"> Key identifier. </param>
        /// <param name="controller"> Key controller - similar to DID issuer. </param>
        /// <param name="type"> Key type. </param>
        /// <param name="publicKeyJwk"> Serialized public key in JWK format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DidDocumentKey(string id, string controller, DidDocumentKeyType type, JsonWebKey publicKeyJwk, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Controller = controller;
            Type = type;
            PublicKeyJwk = publicKeyJwk;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DidDocumentKey"/> for deserialization. </summary>
        internal DidDocumentKey()
        {
        }

        /// <summary> Key identifier. </summary>
        public string Id { get; }
        /// <summary> Key controller - similar to DID issuer. </summary>
        public string Controller { get; }
        /// <summary> Key type. </summary>
        public DidDocumentKeyType Type { get; } = DidDocumentKeyType.JsonWebKey2020;

        /// <summary> Serialized public key in JWK format. </summary>
        public JsonWebKey PublicKeyJwk { get; }
    }
}
