// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Security.CodeTransparency
{
    /// <summary> Configuration of JWT claims. </summary>
    public partial class CodeTransparencyConfigurationAuthenticationJwt
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CodeTransparencyConfigurationAuthenticationJwt"/>. </summary>
        /// <param name="requiredClaims"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="requiredClaims"/> is null. </exception>
        internal CodeTransparencyConfigurationAuthenticationJwt(IReadOnlyDictionary<string, string> requiredClaims)
        {
            Argument.AssertNotNull(requiredClaims, nameof(requiredClaims));

            RequiredClaims = requiredClaims;
        }

        /// <summary> Initializes a new instance of <see cref="CodeTransparencyConfigurationAuthenticationJwt"/>. </summary>
        /// <param name="requiredClaims"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CodeTransparencyConfigurationAuthenticationJwt(IReadOnlyDictionary<string, string> requiredClaims, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RequiredClaims = requiredClaims;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CodeTransparencyConfigurationAuthenticationJwt"/> for deserialization. </summary>
        internal CodeTransparencyConfigurationAuthenticationJwt()
        {
        }

        /// <summary> Gets the required claims. </summary>
        public IReadOnlyDictionary<string, string> RequiredClaims { get; }
    }
}
