// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Security.CodeTransparency
{
    public partial class CodeTransparencyConfigurationAuthentication : IUtf8JsonSerializable, IJsonModel<CodeTransparencyConfigurationAuthentication>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CodeTransparencyConfigurationAuthentication>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CodeTransparencyConfigurationAuthentication>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodeTransparencyConfigurationAuthentication>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CodeTransparencyConfigurationAuthentication)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("allow_unauthenticated"u8);
            writer.WriteBooleanValue(AllowUnauthenticated);
            if (Optional.IsDefined(Jwt))
            {
                writer.WritePropertyName("jwt"u8);
                writer.WriteObjectValue(Jwt, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CodeTransparencyConfigurationAuthentication IJsonModel<CodeTransparencyConfigurationAuthentication>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodeTransparencyConfigurationAuthentication>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CodeTransparencyConfigurationAuthentication)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCodeTransparencyConfigurationAuthentication(document.RootElement, options);
        }

        internal static CodeTransparencyConfigurationAuthentication DeserializeCodeTransparencyConfigurationAuthentication(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool allowUnauthenticated = default;
            CodeTransparencyConfigurationAuthenticationJwt jwt = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("allow_unauthenticated"u8))
                {
                    allowUnauthenticated = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("jwt"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jwt = CodeTransparencyConfigurationAuthenticationJwt.DeserializeCodeTransparencyConfigurationAuthenticationJwt(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CodeTransparencyConfigurationAuthentication(allowUnauthenticated, jwt, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CodeTransparencyConfigurationAuthentication>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodeTransparencyConfigurationAuthentication>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CodeTransparencyConfigurationAuthentication)} does not support writing '{options.Format}' format.");
            }
        }

        CodeTransparencyConfigurationAuthentication IPersistableModel<CodeTransparencyConfigurationAuthentication>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodeTransparencyConfigurationAuthentication>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCodeTransparencyConfigurationAuthentication(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CodeTransparencyConfigurationAuthentication)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CodeTransparencyConfigurationAuthentication>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CodeTransparencyConfigurationAuthentication FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCodeTransparencyConfigurationAuthentication(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
