// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Security.CodeTransparency
{
    /// <summary> Client options for CodeTransparencyClient. </summary>
    public partial class CodeTransparencyClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2024_01_11_Preview;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2024-01-11-preview". </summary>
            V2024_01_11_Preview = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of CodeTransparencyClientOptions. </summary>
        public CodeTransparencyClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2024_01_11_Preview => "2024-01-11-preview",
                _ => throw new NotSupportedException()
            };
        }
    }
}
