// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Security.CodeTransparency
{
    // Data plane generated client.
    /// <summary> The CodeTransparency service client. </summary>
    public partial class CodeTransparencyClient
    {
        private const string AuthorizationHeader = "Authorization";
        private readonly AzureKeyCredential _keyCredential;
        private const string AuthorizationApiKeyPrefix = "Bearer";
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of CodeTransparencyClient for mocking. </summary>
        protected CodeTransparencyClient()
        {
        }

        /// <summary> Initializes a new instance of CodeTransparencyClient. </summary>
        /// <param name="endpoint"> The <see cref="Uri"/> to use. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public CodeTransparencyClient(Uri endpoint, AzureKeyCredential credential) : this(endpoint, credential, new CodeTransparencyClientOptions())
        {
        }

        /// <summary> Get the status the entry operation. </summary>
        /// <param name="operationId"> ID of the operation to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="operationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatusAsync(string,CancellationToken)']/*" />
        public virtual async Task<Response<GetOperationResult>> GetEntryStatusAsync(string operationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(operationId, nameof(operationId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetEntryStatusAsync(operationId, context).ConfigureAwait(false);
            return Response.FromValue(GetOperationResult.FromResponse(response), response);
        }

        /// <summary> Get the status the entry operation. </summary>
        /// <param name="operationId"> ID of the operation to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="operationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatus(string,CancellationToken)']/*" />
        public virtual Response<GetOperationResult> GetEntryStatus(string operationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(operationId, nameof(operationId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetEntryStatus(operationId, context);
            return Response.FromValue(GetOperationResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Get the status the entry operation
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryStatusAsync(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="operationId"> ID of the operation to retrieve. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="operationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatusAsync(string,RequestContext)']/*" />
        public virtual async Task<Response> GetEntryStatusAsync(string operationId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(operationId, nameof(operationId));

            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntryStatus");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryStatusRequest(operationId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get the status the entry operation
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryStatus(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="operationId"> ID of the operation to retrieve. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="operationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatus(string,RequestContext)']/*" />
        public virtual Response GetEntryStatus(string operationId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(operationId, nameof(operationId));

            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntryStatus");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryStatusRequest(operationId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get the status of all entries operations. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatusesAsync(CancellationToken)']/*" />
        public virtual async Task<Response<ListOperationResult>> GetEntryStatusesAsync(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetEntryStatusesAsync(context).ConfigureAwait(false);
            return Response.FromValue(ListOperationResult.FromResponse(response), response);
        }

        /// <summary> Get the status of all entries operations. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatuses(CancellationToken)']/*" />
        public virtual Response<ListOperationResult> GetEntryStatuses(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetEntryStatuses(context);
            return Response.FromValue(ListOperationResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Get the status of all entries operations
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryStatusesAsync(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatusesAsync(RequestContext)']/*" />
        public virtual async Task<Response> GetEntryStatusesAsync(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntryStatuses");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryStatusesRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get the status of all entries operations
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryStatuses(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryStatuses(RequestContext)']/*" />
        public virtual Response GetEntryStatuses(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntryStatuses");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryStatusesRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get Entry with or without receipt embedded in its unprotected header. </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="embedReceipt"> Embed a receipt as part of the response. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryAsync(string,bool?,CancellationToken)']/*" />
        public virtual async Task<Response<BinaryData>> GetEntryAsync(string entryId, bool? embedReceipt = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetEntryAsync(entryId, embedReceipt, context).ConfigureAwait(false);
            return Response.FromValue(response.Content, response);
        }

        /// <summary> Get Entry with or without receipt embedded in its unprotected header. </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="embedReceipt"> Embed a receipt as part of the response. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntry(string,bool?,CancellationToken)']/*" />
        public virtual Response<BinaryData> GetEntry(string entryId, bool? embedReceipt = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetEntry(entryId, embedReceipt, context);
            return Response.FromValue(response.Content, response);
        }

        /// <summary>
        /// [Protocol Method] Get Entry with or without receipt embedded in its unprotected header
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryAsync(string,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="embedReceipt"> Embed a receipt as part of the response. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryAsync(string,bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetEntryAsync(string entryId, bool? embedReceipt, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntry");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryRequest(entryId, embedReceipt, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get Entry with or without receipt embedded in its unprotected header
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntry(string,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="embedReceipt"> Embed a receipt as part of the response. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntry(string,bool?,RequestContext)']/*" />
        public virtual Response GetEntry(string entryId, bool? embedReceipt, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntry");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryRequest(entryId, embedReceipt, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get the receipt of an entry given a specific entry id. </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryReceiptAsync(string,CancellationToken)']/*" />
        public virtual async Task<Response<BinaryData>> GetEntryReceiptAsync(string entryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetEntryReceiptAsync(entryId, context).ConfigureAwait(false);
            return Response.FromValue(response.Content, response);
        }

        /// <summary> Get the receipt of an entry given a specific entry id. </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryReceipt(string,CancellationToken)']/*" />
        public virtual Response<BinaryData> GetEntryReceipt(string entryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetEntryReceipt(entryId, context);
            return Response.FromValue(response.Content, response);
        }

        /// <summary>
        /// [Protocol Method] Get the receipt of an entry given a specific entry id.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryReceiptAsync(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryReceiptAsync(string,RequestContext)']/*" />
        public virtual async Task<Response> GetEntryReceiptAsync(string entryId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntryReceipt");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryReceiptRequest(entryId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get the receipt of an entry given a specific entry id.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryReceipt(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entryId"> ID of the entry to retrieve. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entryId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="entryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryReceipt(string,RequestContext)']/*" />
        public virtual Response GetEntryReceipt(string entryId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(entryId, nameof(entryId));

            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetEntryReceipt");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetEntryReceiptRequest(entryId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get service parameters. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetParametersAsync(CancellationToken)']/*" />
        public virtual async Task<Response<ParametersResult>> GetParametersAsync(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetParametersAsync(context).ConfigureAwait(false);
            return Response.FromValue(ParametersResult.FromResponse(response), response);
        }

        /// <summary> Get service parameters. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetParameters(CancellationToken)']/*" />
        public virtual Response<ParametersResult> GetParameters(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetParameters(context);
            return Response.FromValue(ParametersResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Get service parameters
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetParametersAsync(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetParametersAsync(RequestContext)']/*" />
        public virtual async Task<Response> GetParametersAsync(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetParameters");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetParametersRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get service parameters
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetParameters(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetParameters(RequestContext)']/*" />
        public virtual Response GetParameters(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetParameters");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetParametersRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get the DID configuration file. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetDidConfigAsync(CancellationToken)']/*" />
        public virtual async Task<Response<DidDocument>> GetDidConfigAsync(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetDidConfigAsync(context).ConfigureAwait(false);
            return Response.FromValue(DidDocument.FromResponse(response), response);
        }

        /// <summary> Get the DID configuration file. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetDidConfig(CancellationToken)']/*" />
        public virtual Response<DidDocument> GetDidConfig(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetDidConfig(context);
            return Response.FromValue(DidDocument.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Get the DID configuration file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetDidConfigAsync(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetDidConfigAsync(RequestContext)']/*" />
        public virtual async Task<Response> GetDidConfigAsync(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetDidConfig");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetDidConfigRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get the DID configuration file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetDidConfig(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetDidConfig(RequestContext)']/*" />
        public virtual Response GetDidConfig(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetDidConfig");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetDidConfigRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get CodeTransparency configuration information. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyConfigAsync(CancellationToken)']/*" />
        public virtual async Task<Response<CodeTransparencyConfiguration>> GetCodeTransparencyConfigAsync(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetCodeTransparencyConfigAsync(context).ConfigureAwait(false);
            return Response.FromValue(CodeTransparencyConfiguration.FromResponse(response), response);
        }

        /// <summary> Get CodeTransparency configuration information. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyConfig(CancellationToken)']/*" />
        public virtual Response<CodeTransparencyConfiguration> GetCodeTransparencyConfig(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetCodeTransparencyConfig(context);
            return Response.FromValue(CodeTransparencyConfiguration.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Get CodeTransparency configuration information.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetCodeTransparencyConfigAsync(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyConfigAsync(RequestContext)']/*" />
        public virtual async Task<Response> GetCodeTransparencyConfigAsync(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetCodeTransparencyConfig");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetCodeTransparencyConfigRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get CodeTransparency configuration information.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetCodeTransparencyConfig(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyConfig(RequestContext)']/*" />
        public virtual Response GetCodeTransparencyConfig(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetCodeTransparencyConfig");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetCodeTransparencyConfigRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get CodeTransparency version information. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyVersionAsync(CancellationToken)']/*" />
        public virtual async Task<Response<VersionResult>> GetCodeTransparencyVersionAsync(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetCodeTransparencyVersionAsync(context).ConfigureAwait(false);
            return Response.FromValue(VersionResult.FromResponse(response), response);
        }

        /// <summary> Get CodeTransparency version information. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyVersion(CancellationToken)']/*" />
        public virtual Response<VersionResult> GetCodeTransparencyVersion(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetCodeTransparencyVersion(context);
            return Response.FromValue(VersionResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Get CodeTransparency version information.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetCodeTransparencyVersionAsync(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyVersionAsync(RequestContext)']/*" />
        public virtual async Task<Response> GetCodeTransparencyVersionAsync(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetCodeTransparencyVersion");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetCodeTransparencyVersionRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get CodeTransparency version information.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetCodeTransparencyVersion(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetCodeTransparencyVersion(RequestContext)']/*" />
        public virtual Response GetCodeTransparencyVersion(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("CodeTransparencyClient.GetCodeTransparencyVersion");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetCodeTransparencyVersionRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Historical query to get a list of entries of a given range. </summary>
        /// <param name="from"> Starting Transaction Id. </param>
        /// <param name="to"> Ending Transaction Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryIdsAsync(long?,long?,CancellationToken)']/*" />
        public virtual AsyncPageable<string> GetEntryIdsAsync(long? @from = null, long? to = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetEntryIdsRequest(@from, to, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetEntryIdsNextPageRequest(nextLink, @from, to, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => e.GetString(), ClientDiagnostics, _pipeline, "CodeTransparencyClient.GetEntryIds", "transactionIds", "nextLink", context);
        }

        /// <summary> Historical query to get a list of entries of a given range. </summary>
        /// <param name="from"> Starting Transaction Id. </param>
        /// <param name="to"> Ending Transaction Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryIds(long?,long?,CancellationToken)']/*" />
        public virtual Pageable<string> GetEntryIds(long? @from = null, long? to = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetEntryIdsRequest(@from, to, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetEntryIdsNextPageRequest(nextLink, @from, to, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => e.GetString(), ClientDiagnostics, _pipeline, "CodeTransparencyClient.GetEntryIds", "transactionIds", "nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Historical query to get a list of entries of a given range
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryIdsAsync(long?,long?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="from"> Starting Transaction Id. </param>
        /// <param name="to"> Ending Transaction Id. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryIdsAsync(long?,long?,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetEntryIdsAsync(long? @from, long? to, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetEntryIdsRequest(@from, to, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetEntryIdsNextPageRequest(nextLink, @from, to, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "CodeTransparencyClient.GetEntryIds", "transactionIds", "nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Historical query to get a list of entries of a given range
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetEntryIds(long?,long?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="from"> Starting Transaction Id. </param>
        /// <param name="to"> Ending Transaction Id. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/CodeTransparencyClient.xml" path="doc/members/member[@name='GetEntryIds(long?,long?,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetEntryIds(long? @from, long? to, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetEntryIdsRequest(@from, to, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetEntryIdsNextPageRequest(nextLink, @from, to, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "CodeTransparencyClient.GetEntryIds", "transactionIds", "nextLink", context);
        }

        internal HttpMessage CreateGetEntryStatusRequest(string operationId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/operations/", false);
            uri.AppendPath(operationId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetEntryStatusesRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/operations", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetEntryRequest(string entryId, bool? embedReceipt, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/entries/", false);
            uri.AppendPath(entryId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (embedReceipt != null)
            {
                uri.AppendQuery("embedReceipt", embedReceipt.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/cose");
            return message;
        }

        internal HttpMessage CreateGetEntryReceiptRequest(string entryId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/entries/", false);
            uri.AppendPath(entryId, true);
            uri.AppendPath("/receipt", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/cbor");
            return message;
        }

        internal HttpMessage CreateGetEntryIdsRequest(long? @from, long? to, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/entries/txIds", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (@from != null)
            {
                uri.AppendQuery("from", @from.Value, true);
            }
            if (to != null)
            {
                uri.AppendQuery("to", to.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetParametersRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/parameters", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetDidConfigRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/.well-known/did.json", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetCodeTransparencyConfigRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/configuration", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetCodeTransparencyVersionRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/version", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetEntryIdsNextPageRequest(string nextLink, long? @from, long? to, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        private static RequestContext DefaultRequestContext = new RequestContext();
        internal static RequestContext FromCancellationToken(CancellationToken cancellationToken = default)
        {
            if (!cancellationToken.CanBeCanceled)
            {
                return DefaultRequestContext;
            }

            return new RequestContext() { CancellationToken = cancellationToken };
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
    }
}
