// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConfidentialLedger.Models
{
    /// <summary> Type of the ledger. Private means transaction data is encrypted. </summary>
    public readonly partial struct ConfidentialLedgerType : IEquatable<ConfidentialLedgerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfidentialLedgerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfidentialLedgerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PublicValue = "Public";
        private const string PrivateValue = "Private";

        /// <summary> Unknown. </summary>
        public static ConfidentialLedgerType Unknown { get; } = new ConfidentialLedgerType(UnknownValue);
        /// <summary> Public. </summary>
        public static ConfidentialLedgerType Public { get; } = new ConfidentialLedgerType(PublicValue);
        /// <summary> Private. </summary>
        public static ConfidentialLedgerType Private { get; } = new ConfidentialLedgerType(PrivateValue);
        /// <summary> Determines if two <see cref="ConfidentialLedgerType"/> values are the same. </summary>
        public static bool operator ==(ConfidentialLedgerType left, ConfidentialLedgerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfidentialLedgerType"/> values are not the same. </summary>
        public static bool operator !=(ConfidentialLedgerType left, ConfidentialLedgerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfidentialLedgerType"/>. </summary>
        public static implicit operator ConfidentialLedgerType(string value) => new ConfidentialLedgerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfidentialLedgerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfidentialLedgerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
