// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConfidentialLedger.Models
{
    /// <summary> SKU associated with the ledger resource. </summary>
    public readonly partial struct ConfidentialLedgerSku : IEquatable<ConfidentialLedgerSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfidentialLedgerSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfidentialLedgerSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string BasicValue = "Basic";
        private const string UnknownValue = "Unknown";

        /// <summary> Standard. </summary>
        public static ConfidentialLedgerSku Standard { get; } = new ConfidentialLedgerSku(StandardValue);
        /// <summary> Basic. </summary>
        public static ConfidentialLedgerSku Basic { get; } = new ConfidentialLedgerSku(BasicValue);
        /// <summary> Unknown. </summary>
        public static ConfidentialLedgerSku Unknown { get; } = new ConfidentialLedgerSku(UnknownValue);
        /// <summary> Determines if two <see cref="ConfidentialLedgerSku"/> values are the same. </summary>
        public static bool operator ==(ConfidentialLedgerSku left, ConfidentialLedgerSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfidentialLedgerSku"/> values are not the same. </summary>
        public static bool operator !=(ConfidentialLedgerSku left, ConfidentialLedgerSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfidentialLedgerSku"/>. </summary>
        public static implicit operator ConfidentialLedgerSku(string value) => new ConfidentialLedgerSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfidentialLedgerSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfidentialLedgerSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
