// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConfidentialLedger.Models
{
    /// <summary> Object representing RunningState for Confidential Ledger. </summary>
    public readonly partial struct ConfidentialLedgerRunningState : IEquatable<ConfidentialLedgerRunningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfidentialLedgerRunningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfidentialLedgerRunningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string PausedValue = "Paused";
        private const string UnknownValue = "Unknown";
        private const string PausingValue = "Pausing";
        private const string ResumingValue = "Resuming";

        /// <summary> Active. </summary>
        public static ConfidentialLedgerRunningState Active { get; } = new ConfidentialLedgerRunningState(ActiveValue);
        /// <summary> Paused. </summary>
        public static ConfidentialLedgerRunningState Paused { get; } = new ConfidentialLedgerRunningState(PausedValue);
        /// <summary> Unknown. </summary>
        public static ConfidentialLedgerRunningState Unknown { get; } = new ConfidentialLedgerRunningState(UnknownValue);
        /// <summary> Pausing. </summary>
        public static ConfidentialLedgerRunningState Pausing { get; } = new ConfidentialLedgerRunningState(PausingValue);
        /// <summary> Resuming. </summary>
        public static ConfidentialLedgerRunningState Resuming { get; } = new ConfidentialLedgerRunningState(ResumingValue);
        /// <summary> Determines if two <see cref="ConfidentialLedgerRunningState"/> values are the same. </summary>
        public static bool operator ==(ConfidentialLedgerRunningState left, ConfidentialLedgerRunningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfidentialLedgerRunningState"/> values are not the same. </summary>
        public static bool operator !=(ConfidentialLedgerRunningState left, ConfidentialLedgerRunningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfidentialLedgerRunningState"/>. </summary>
        public static implicit operator ConfidentialLedgerRunningState(string value) => new ConfidentialLedgerRunningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfidentialLedgerRunningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfidentialLedgerRunningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
