// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConfidentialLedger.Models
{
    /// <summary> Object representing ProvisioningState for Confidential Ledger. </summary>
    public readonly partial struct ConfidentialLedgerProvisioningState : IEquatable<ConfidentialLedgerProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfidentialLedgerProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfidentialLedgerProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Unknown. </summary>
        public static ConfidentialLedgerProvisioningState Unknown { get; } = new ConfidentialLedgerProvisioningState(UnknownValue);
        /// <summary> Succeeded. </summary>
        public static ConfidentialLedgerProvisioningState Succeeded { get; } = new ConfidentialLedgerProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ConfidentialLedgerProvisioningState Failed { get; } = new ConfidentialLedgerProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ConfidentialLedgerProvisioningState Canceled { get; } = new ConfidentialLedgerProvisioningState(CanceledValue);
        /// <summary> Creating. </summary>
        public static ConfidentialLedgerProvisioningState Creating { get; } = new ConfidentialLedgerProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static ConfidentialLedgerProvisioningState Deleting { get; } = new ConfidentialLedgerProvisioningState(DeletingValue);
        /// <summary> Updating. </summary>
        public static ConfidentialLedgerProvisioningState Updating { get; } = new ConfidentialLedgerProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="ConfidentialLedgerProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ConfidentialLedgerProvisioningState left, ConfidentialLedgerProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfidentialLedgerProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ConfidentialLedgerProvisioningState left, ConfidentialLedgerProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfidentialLedgerProvisioningState"/>. </summary>
        public static implicit operator ConfidentialLedgerProvisioningState(string value) => new ConfidentialLedgerProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfidentialLedgerProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfidentialLedgerProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
