// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConfidentialLedger.Models
{
    /// <summary> Object representing LanguageRuntime for Manged CCF. </summary>
    public readonly partial struct ConfidentialLedgerLanguageRuntime : IEquatable<ConfidentialLedgerLanguageRuntime>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfidentialLedgerLanguageRuntime"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfidentialLedgerLanguageRuntime(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CPPValue = "CPP";
        private const string JSValue = "JS";

        /// <summary> CPP. </summary>
        public static ConfidentialLedgerLanguageRuntime CPP { get; } = new ConfidentialLedgerLanguageRuntime(CPPValue);
        /// <summary> JS. </summary>
        public static ConfidentialLedgerLanguageRuntime JS { get; } = new ConfidentialLedgerLanguageRuntime(JSValue);
        /// <summary> Determines if two <see cref="ConfidentialLedgerLanguageRuntime"/> values are the same. </summary>
        public static bool operator ==(ConfidentialLedgerLanguageRuntime left, ConfidentialLedgerLanguageRuntime right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfidentialLedgerLanguageRuntime"/> values are not the same. </summary>
        public static bool operator !=(ConfidentialLedgerLanguageRuntime left, ConfidentialLedgerLanguageRuntime right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfidentialLedgerLanguageRuntime"/>. </summary>
        public static implicit operator ConfidentialLedgerLanguageRuntime(string value) => new ConfidentialLedgerLanguageRuntime(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfidentialLedgerLanguageRuntime other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfidentialLedgerLanguageRuntime other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
