// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConfidentialLedger.Models
{
    /// <summary> Object representing DeploymentType for Managed CCF. </summary>
    public partial class ConfidentialLedgerDeploymentType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConfidentialLedgerDeploymentType"/>. </summary>
        public ConfidentialLedgerDeploymentType()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConfidentialLedgerDeploymentType"/>. </summary>
        /// <param name="languageRuntime"> Unique name for the Managed CCF. </param>
        /// <param name="appSourceUri"> Source Uri containing ManagedCCF code. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConfidentialLedgerDeploymentType(ConfidentialLedgerLanguageRuntime? languageRuntime, Uri appSourceUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LanguageRuntime = languageRuntime;
            AppSourceUri = appSourceUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique name for the Managed CCF. </summary>
        public ConfidentialLedgerLanguageRuntime? LanguageRuntime { get; set; }
        /// <summary> Source Uri containing ManagedCCF code. </summary>
        public Uri AppSourceUri { get; set; }
    }
}
