// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.ConfidentialLedger.Models;

namespace Azure.ResourceManager.ConfidentialLedger
{
    internal class ManagedCcfRestoreResultOperationSource : IOperationSource<ManagedCcfRestoreResult>
    {
        ManagedCcfRestoreResult IOperationSource<ManagedCcfRestoreResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ManagedCcfRestoreResult.DeserializeManagedCcfRestoreResult(document.RootElement);
        }

        async ValueTask<ManagedCcfRestoreResult> IOperationSource<ManagedCcfRestoreResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ManagedCcfRestoreResult.DeserializeManagedCcfRestoreResult(document.RootElement);
        }
    }
}
