// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.ConfidentialLedger.Models;

namespace Azure.ResourceManager.ConfidentialLedger
{
    internal class ConfidentialLedgerBackupResultOperationSource : IOperationSource<ConfidentialLedgerBackupResult>
    {
        ConfidentialLedgerBackupResult IOperationSource<ConfidentialLedgerBackupResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ConfidentialLedgerBackupResult.DeserializeConfidentialLedgerBackupResult(document.RootElement);
        }

        async ValueTask<ConfidentialLedgerBackupResult> IOperationSource<ConfidentialLedgerBackupResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ConfidentialLedgerBackupResult.DeserializeConfidentialLedgerBackupResult(document.RootElement);
        }
    }
}
