// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ConfidentialLedger.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableConfidentialLedgerArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableConfidentialLedgerArmClient"/> class for mocking. </summary>
        protected MockableConfidentialLedgerArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableConfidentialLedgerArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableConfidentialLedgerArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableConfidentialLedgerArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConfidentialLedgerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConfidentialLedgerResource.CreateResourceIdentifier" /> to create a <see cref="ConfidentialLedgerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ConfidentialLedgerResource"/> object. </returns>
        public virtual ConfidentialLedgerResource GetConfidentialLedgerResource(ResourceIdentifier id)
        {
            ConfidentialLedgerResource.ValidateResourceId(id);
            return new ConfidentialLedgerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedCcfResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedCcfResource.CreateResourceIdentifier" /> to create a <see cref="ManagedCcfResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedCcfResource"/> object. </returns>
        public virtual ManagedCcfResource GetManagedCcfResource(ResourceIdentifier id)
        {
            ManagedCcfResource.ValidateResourceId(id);
            return new ManagedCcfResource(Client, id);
        }
    }
}
