// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    /// <summary> The schedule details for the user request. </summary>
    public partial class UserRequestSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserRequestSchedule"/>. </summary>
        /// <param name="deadLine"> The deadline for the operation. </param>
        /// <param name="timeZone"> The timezone for the operation. </param>
        /// <param name="deadlineType"> The deadlinetype of the operation, this can either be InitiateAt or CompleteBy. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="timeZone"/> is null. </exception>
        public UserRequestSchedule(DateTimeOffset deadLine, string timeZone, ScheduledActionDeadlineType deadlineType)
        {
            Argument.AssertNotNull(timeZone, nameof(timeZone));

            DeadLine = deadLine;
            TimeZone = timeZone;
            DeadlineType = deadlineType;
        }

        /// <summary> Initializes a new instance of <see cref="UserRequestSchedule"/>. </summary>
        /// <param name="deadLine"> The deadline for the operation. </param>
        /// <param name="timeZone"> The timezone for the operation. </param>
        /// <param name="deadlineType"> The deadlinetype of the operation, this can either be InitiateAt or CompleteBy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserRequestSchedule(DateTimeOffset deadLine, string timeZone, ScheduledActionDeadlineType deadlineType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeadLine = deadLine;
            TimeZone = timeZone;
            DeadlineType = deadlineType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UserRequestSchedule"/> for deserialization. </summary>
        internal UserRequestSchedule()
        {
        }

        /// <summary> The deadline for the operation. </summary>
        public DateTimeOffset DeadLine { get; }
        /// <summary> The timezone for the operation. </summary>
        public string TimeZone { get; }
        /// <summary> The deadlinetype of the operation, this can either be InitiateAt or CompleteBy. </summary>
        public ScheduledActionDeadlineType DeadlineType { get; }
    }
}
