// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    /// <summary> The resources needed for the user request. </summary>
    public partial class UserRequestResources
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserRequestResources"/>. </summary>
        /// <param name="ids"> The resource ids used for the request. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ids"/> is null. </exception>
        public UserRequestResources(IEnumerable<ResourceIdentifier> ids)
        {
            Argument.AssertNotNull(ids, nameof(ids));

            Ids = ids.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="UserRequestResources"/>. </summary>
        /// <param name="ids"> The resource ids used for the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserRequestResources(IList<ResourceIdentifier> ids, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ids = ids;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UserRequestResources"/> for deserialization. </summary>
        internal UserRequestResources()
        {
        }

        /// <summary> The resource ids used for the request. </summary>
        public IList<ResourceIdentifier> Ids { get; }
    }
}
