// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    public partial class ScheduledActionExecutionParameterDetail : IUtf8JsonSerializable, IJsonModel<ScheduledActionExecutionParameterDetail>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScheduledActionExecutionParameterDetail>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScheduledActionExecutionParameterDetail>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledActionExecutionParameterDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledActionExecutionParameterDetail)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(OptimizationPreference))
            {
                writer.WritePropertyName("optimizationPreference"u8);
                writer.WriteStringValue(OptimizationPreference.Value.ToString());
            }
            if (Optional.IsDefined(RetryPolicy))
            {
                writer.WritePropertyName("retryPolicy"u8);
                writer.WriteObjectValue(RetryPolicy, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScheduledActionExecutionParameterDetail IJsonModel<ScheduledActionExecutionParameterDetail>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledActionExecutionParameterDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScheduledActionExecutionParameterDetail)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScheduledActionExecutionParameterDetail(document.RootElement, options);
        }

        internal static ScheduledActionExecutionParameterDetail DeserializeScheduledActionExecutionParameterDetail(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ScheduledActionOptimizationPreference? optimizationPreference = default;
            UserRequestRetryPolicy retryPolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("optimizationPreference"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    optimizationPreference = new ScheduledActionOptimizationPreference(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("retryPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    retryPolicy = UserRequestRetryPolicy.DeserializeUserRequestRetryPolicy(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScheduledActionExecutionParameterDetail(optimizationPreference, retryPolicy, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScheduledActionExecutionParameterDetail>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledActionExecutionParameterDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScheduledActionExecutionParameterDetail)} does not support writing '{options.Format}' format.");
            }
        }

        ScheduledActionExecutionParameterDetail IPersistableModel<ScheduledActionExecutionParameterDetail>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScheduledActionExecutionParameterDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScheduledActionExecutionParameterDetail(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScheduledActionExecutionParameterDetail)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScheduledActionExecutionParameterDetail>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
