// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    /// <summary> The kind of operation types that can be performed on resources using ScheduledActions. </summary>
    public readonly partial struct ResourceOperationType : IEquatable<ResourceOperationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceOperationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceOperationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string StartValue = "Start";
        private const string DeallocateValue = "Deallocate";
        private const string HibernateValue = "Hibernate";

        /// <summary> The default value for this enum type. </summary>
        public static ResourceOperationType Unknown { get; } = new ResourceOperationType(UnknownValue);
        /// <summary> Start operations on the resources. </summary>
        public static ResourceOperationType Start { get; } = new ResourceOperationType(StartValue);
        /// <summary> Deallocate operations on the resources. </summary>
        public static ResourceOperationType Deallocate { get; } = new ResourceOperationType(DeallocateValue);
        /// <summary> Hibernate operations on the resources. </summary>
        public static ResourceOperationType Hibernate { get; } = new ResourceOperationType(HibernateValue);
        /// <summary> Determines if two <see cref="ResourceOperationType"/> values are the same. </summary>
        public static bool operator ==(ResourceOperationType left, ResourceOperationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceOperationType"/> values are not the same. </summary>
        public static bool operator !=(ResourceOperationType left, ResourceOperationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceOperationType"/>. </summary>
        public static implicit operator ResourceOperationType(string value) => new ResourceOperationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceOperationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceOperationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
