// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    /// <summary> The details of a response from an operation on a resource. </summary>
    public partial class ResourceOperationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation identifier for the unique operation. </param>
        /// <param name="resourceId"> Unique identifier for the resource involved in the operation, eg ArmId. </param>
        /// <param name="opType"> Type of operation performed on the resources. </param>
        /// <param name="subscriptionId"> Subscription id attached to the request. </param>
        /// <param name="deadline"> Deadline for the operation. </param>
        /// <param name="deadlineType"> Type of deadline of the operation. </param>
        /// <param name="state"> Current state of the operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/>, <paramref name="resourceId"/> or <paramref name="subscriptionId"/> is null. </exception>
        internal ResourceOperationDetails(string operationId, ResourceIdentifier resourceId, ResourceOperationType opType, string subscriptionId, DateTimeOffset deadline, ScheduledActionDeadlineType deadlineType, ScheduledActionOperationState state)
        {
            Argument.AssertNotNull(operationId, nameof(operationId));
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNull(subscriptionId, nameof(subscriptionId));

            OperationId = operationId;
            ResourceId = resourceId;
            OpType = opType;
            SubscriptionId = subscriptionId;
            Deadline = deadline;
            DeadlineType = deadlineType;
            State = state;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation identifier for the unique operation. </param>
        /// <param name="resourceId"> Unique identifier for the resource involved in the operation, eg ArmId. </param>
        /// <param name="opType"> Type of operation performed on the resources. </param>
        /// <param name="subscriptionId"> Subscription id attached to the request. </param>
        /// <param name="deadline"> Deadline for the operation. </param>
        /// <param name="deadlineType"> Type of deadline of the operation. </param>
        /// <param name="state"> Current state of the operation. </param>
        /// <param name="timeZone"> Timezone for the operation. </param>
        /// <param name="resourceOperationError"> Operation level errors if they exist. </param>
        /// <param name="completedOn"> Time the operation was complete if errors are null. </param>
        /// <param name="retryPolicy"> Retry policy the user can pass. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceOperationDetails(string operationId, ResourceIdentifier resourceId, ResourceOperationType opType, string subscriptionId, DateTimeOffset deadline, ScheduledActionDeadlineType deadlineType, ScheduledActionOperationState state, string timeZone, ResourceOperationError resourceOperationError, DateTimeOffset? completedOn, UserRequestRetryPolicy retryPolicy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OperationId = operationId;
            ResourceId = resourceId;
            OpType = opType;
            SubscriptionId = subscriptionId;
            Deadline = deadline;
            DeadlineType = deadlineType;
            State = state;
            TimeZone = timeZone;
            ResourceOperationError = resourceOperationError;
            CompletedOn = completedOn;
            RetryPolicy = retryPolicy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceOperationDetails"/> for deserialization. </summary>
        internal ResourceOperationDetails()
        {
        }

        /// <summary> Operation identifier for the unique operation. </summary>
        public string OperationId { get; }
        /// <summary> Unique identifier for the resource involved in the operation, eg ArmId. </summary>
        public ResourceIdentifier ResourceId { get; }
        /// <summary> Type of operation performed on the resources. </summary>
        public ResourceOperationType OpType { get; }
        /// <summary> Subscription id attached to the request. </summary>
        public string SubscriptionId { get; }
        /// <summary> Deadline for the operation. </summary>
        public DateTimeOffset Deadline { get; }
        /// <summary> Type of deadline of the operation. </summary>
        public ScheduledActionDeadlineType DeadlineType { get; }
        /// <summary> Current state of the operation. </summary>
        public ScheduledActionOperationState State { get; }
        /// <summary> Timezone for the operation. </summary>
        public string TimeZone { get; }
        /// <summary> Operation level errors if they exist. </summary>
        public ResourceOperationError ResourceOperationError { get; }
        /// <summary> Time the operation was complete if errors are null. </summary>
        public DateTimeOffset? CompletedOn { get; }
        /// <summary> Retry policy the user can pass. </summary>
        public UserRequestRetryPolicy RetryPolicy { get; }
    }
}
