// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    /// <summary> This defines a list of operation errors associated with a unique operationId. </summary>
    public partial class OperationErrorDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code of the operation. </param>
        /// <param name="errorDetails"> The error details of the operation. </param>
        /// <param name="timeStamp"> The timestamp of the error occurence. </param>
        /// <param name="crpOperationId"> CRP operationid of the operation for deeper analysis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="errorCode"/> or <paramref name="crpOperationId"/> is null. </exception>
        internal OperationErrorDetails(string errorCode, DateTimeOffset errorDetails, DateTimeOffset timeStamp, string crpOperationId)
        {
            Argument.AssertNotNull(errorCode, nameof(errorCode));
            Argument.AssertNotNull(crpOperationId, nameof(crpOperationId));

            ErrorCode = errorCode;
            ErrorDetails = errorDetails;
            TimeStamp = timeStamp;
            CrpOperationId = crpOperationId;
        }

        /// <summary> Initializes a new instance of <see cref="OperationErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code of the operation. </param>
        /// <param name="errorDetails"> The error details of the operation. </param>
        /// <param name="timeStamp"> The timestamp of the error occurence. </param>
        /// <param name="crpOperationId"> CRP operationid of the operation for deeper analysis. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationErrorDetails(string errorCode, DateTimeOffset errorDetails, DateTimeOffset timeStamp, string crpOperationId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ErrorCode = errorCode;
            ErrorDetails = errorDetails;
            TimeStamp = timeStamp;
            CrpOperationId = crpOperationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OperationErrorDetails"/> for deserialization. </summary>
        internal OperationErrorDetails()
        {
        }

        /// <summary> The error code of the operation. </summary>
        public string ErrorCode { get; }
        /// <summary> The error details of the operation. </summary>
        public DateTimeOffset ErrorDetails { get; }
        /// <summary> The timestamp of the error occurence. </summary>
        public DateTimeOffset TimeStamp { get; }
        /// <summary> CRP operationid of the operation for deeper analysis. </summary>
        public string CrpOperationId { get; }
    }
}
