// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    /// <summary> This is the request to get errors per vm operations. </summary>
    public partial class GetOperationErrorsContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GetOperationErrorsContent"/>. </summary>
        /// <param name="operationIds"> The list of operation ids to query errors of. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationIds"/> is null. </exception>
        public GetOperationErrorsContent(IEnumerable<string> operationIds)
        {
            Argument.AssertNotNull(operationIds, nameof(operationIds));

            OperationIds = operationIds.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GetOperationErrorsContent"/>. </summary>
        /// <param name="operationIds"> The list of operation ids to query errors of. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GetOperationErrorsContent(IList<string> operationIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OperationIds = operationIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GetOperationErrorsContent"/> for deserialization. </summary>
        internal GetOperationErrorsContent()
        {
        }

        /// <summary> The list of operation ids to query errors of. </summary>
        public IList<string> OperationIds { get; }
    }
}
