// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.ComputeSchedule.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmComputeScheduleModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.DeallocateResourceOperationResult"/>. </summary>
        /// <param name="description"> The description of the operation response. </param>
        /// <param name="resourceType"> The type of resources used in the deallocate request eg virtual machines. </param>
        /// <param name="location"> The location of the deallocate request eg westus. </param>
        /// <param name="results"> The results from the deallocate request if no errors exist. </param>
        /// <returns> A new <see cref="Models.DeallocateResourceOperationResult"/> instance for mocking. </returns>
        public static DeallocateResourceOperationResult DeallocateResourceOperationResult(string description = null, string resourceType = null, AzureLocation location = default, IEnumerable<ResourceOperationResult> results = null)
        {
            results ??= new List<ResourceOperationResult>();

            return new DeallocateResourceOperationResult(description, resourceType, location, results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceOperationResult"/>. </summary>
        /// <param name="resourceId"> Unique identifier for the resource involved in the operation, eg ArmId. </param>
        /// <param name="errorCode"> Resource level error code if it exists. </param>
        /// <param name="errorDetails"> Resource level error details if they exist. </param>
        /// <param name="operation"> Details of the operation performed on a resource. </param>
        /// <returns> A new <see cref="Models.ResourceOperationResult"/> instance for mocking. </returns>
        public static ResourceOperationResult ResourceOperationResult(ResourceIdentifier resourceId = null, string errorCode = null, string errorDetails = null, ResourceOperationDetails operation = null)
        {
            return new ResourceOperationResult(resourceId, errorCode, errorDetails, operation, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation identifier for the unique operation. </param>
        /// <param name="resourceId"> Unique identifier for the resource involved in the operation, eg ArmId. </param>
        /// <param name="opType"> Type of operation performed on the resources. </param>
        /// <param name="subscriptionId"> Subscription id attached to the request. </param>
        /// <param name="deadline"> Deadline for the operation. </param>
        /// <param name="deadlineType"> Type of deadline of the operation. </param>
        /// <param name="state"> Current state of the operation. </param>
        /// <param name="timeZone"> Timezone for the operation. </param>
        /// <param name="resourceOperationError"> Operation level errors if they exist. </param>
        /// <param name="completedOn"> Time the operation was complete if errors are null. </param>
        /// <param name="retryPolicy"> Retry policy the user can pass. </param>
        /// <returns> A new <see cref="Models.ResourceOperationDetails"/> instance for mocking. </returns>
        public static ResourceOperationDetails ResourceOperationDetails(string operationId = null, ResourceIdentifier resourceId = null, ResourceOperationType opType = default, string subscriptionId = null, DateTimeOffset deadline = default, ScheduledActionDeadlineType deadlineType = default, ScheduledActionOperationState state = default, string timeZone = null, ResourceOperationError resourceOperationError = null, DateTimeOffset? completedOn = null, UserRequestRetryPolicy retryPolicy = null)
        {
            return new ResourceOperationDetails(
                operationId,
                resourceId,
                opType,
                subscriptionId,
                deadline,
                deadlineType,
                state,
                timeZone,
                resourceOperationError,
                completedOn,
                retryPolicy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceOperationError"/>. </summary>
        /// <param name="errorCode"> Code for the error eg 404, 500. </param>
        /// <param name="errorDetails"> Detailed message about the error. </param>
        /// <returns> A new <see cref="Models.ResourceOperationError"/> instance for mocking. </returns>
        public static ResourceOperationError ResourceOperationError(string errorCode = null, string errorDetails = null)
        {
            return new ResourceOperationError(errorCode, errorDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HibernateResourceOperationResult"/>. </summary>
        /// <param name="description"> The description of the operation response. </param>
        /// <param name="resourceType"> The type of resources used in the Hibernate request eg virtual machines. </param>
        /// <param name="location"> The location of the Hibernate request eg westus. </param>
        /// <param name="results"> The results from the Hibernate request if no errors exist. </param>
        /// <returns> A new <see cref="Models.HibernateResourceOperationResult"/> instance for mocking. </returns>
        public static HibernateResourceOperationResult HibernateResourceOperationResult(string description = null, string resourceType = null, AzureLocation location = default, IEnumerable<ResourceOperationResult> results = null)
        {
            results ??= new List<ResourceOperationResult>();

            return new HibernateResourceOperationResult(description, resourceType, location, results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StartResourceOperationResult"/>. </summary>
        /// <param name="description"> The description of the operation response. </param>
        /// <param name="resourceType"> The type of resources used in the start request eg virtual machines. </param>
        /// <param name="location"> The location of the start request eg westus. </param>
        /// <param name="results"> The results from the start request if no errors exist. </param>
        /// <returns> A new <see cref="Models.StartResourceOperationResult"/> instance for mocking. </returns>
        public static StartResourceOperationResult StartResourceOperationResult(string description = null, string resourceType = null, AzureLocation location = default, IEnumerable<ResourceOperationResult> results = null)
        {
            results ??= new List<ResourceOperationResult>();

            return new StartResourceOperationResult(description, resourceType, location, results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetOperationStatusResult"/>. </summary>
        /// <param name="results"> An array of resource operations based on their operation ids. </param>
        /// <returns> A new <see cref="Models.GetOperationStatusResult"/> instance for mocking. </returns>
        public static GetOperationStatusResult GetOperationStatusResult(IEnumerable<ResourceOperationResult> results = null)
        {
            results ??= new List<ResourceOperationResult>();

            return new GetOperationStatusResult(results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CancelOperationsResult"/>. </summary>
        /// <param name="results"> An array of resource operations that were successfully cancelled. </param>
        /// <returns> A new <see cref="Models.CancelOperationsResult"/> instance for mocking. </returns>
        public static CancelOperationsResult CancelOperationsResult(IEnumerable<ResourceOperationResult> results = null)
        {
            results ??= new List<ResourceOperationResult>();

            return new CancelOperationsResult(results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetOperationErrorsResult"/>. </summary>
        /// <param name="results"> An array of operationids and their corresponding errors if any. </param>
        /// <returns> A new <see cref="Models.GetOperationErrorsResult"/> instance for mocking. </returns>
        public static GetOperationErrorsResult GetOperationErrorsResult(IEnumerable<OperationErrorsResult> results = null)
        {
            results ??= new List<OperationErrorsResult>();

            return new GetOperationErrorsResult(results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationErrorsResult"/>. </summary>
        /// <param name="operationId"> The operationId identifying a vm operation. </param>
        /// <param name="createdOn"> The creation time of the error result. </param>
        /// <param name="activationOn"> The activation time of a vm operation. </param>
        /// <param name="completedOn"> The completion time of the operation if the operation was completed. </param>
        /// <param name="operationErrors"> A list of errors associated with the operationid. </param>
        /// <param name="requestErrorCode"> Request level error code. </param>
        /// <param name="requestErrorDetails"> Request level error details. </param>
        /// <returns> A new <see cref="Models.OperationErrorsResult"/> instance for mocking. </returns>
        public static OperationErrorsResult OperationErrorsResult(string operationId = null, DateTimeOffset? createdOn = null, DateTimeOffset? activationOn = null, DateTimeOffset? completedOn = null, IEnumerable<OperationErrorDetails> operationErrors = null, string requestErrorCode = null, string requestErrorDetails = null)
        {
            operationErrors ??= new List<OperationErrorDetails>();

            return new OperationErrorsResult(
                operationId,
                createdOn,
                activationOn,
                completedOn,
                operationErrors?.ToList(),
                requestErrorCode,
                requestErrorDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code of the operation. </param>
        /// <param name="errorDetails"> The error details of the operation. </param>
        /// <param name="timeStamp"> The timestamp of the error occurence. </param>
        /// <param name="crpOperationId"> CRP operationid of the operation for deeper analysis. </param>
        /// <returns> A new <see cref="Models.OperationErrorDetails"/> instance for mocking. </returns>
        public static OperationErrorDetails OperationErrorDetails(string errorCode = null, DateTimeOffset errorDetails = default, DateTimeOffset timeStamp = default, string crpOperationId = null)
        {
            return new OperationErrorDetails(errorCode, errorDetails, timeStamp, crpOperationId, serializedAdditionalRawData: null);
        }
    }
}
