// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> The WindowsSetupAdditionalInformation_componentName. </summary>
    public readonly partial struct WindowsSetupAdditionalInformationComponentName : IEquatable<WindowsSetupAdditionalInformationComponentName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WindowsSetupAdditionalInformationComponentName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WindowsSetupAdditionalInformationComponentName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftWindowsShellSetupValue = "Microsoft-Windows-Shell-Setup";

        /// <summary> Microsoft-Windows-Shell-Setup. </summary>
        public static WindowsSetupAdditionalInformationComponentName MicrosoftWindowsShellSetup { get; } = new WindowsSetupAdditionalInformationComponentName(MicrosoftWindowsShellSetupValue);
        /// <summary> Determines if two <see cref="WindowsSetupAdditionalInformationComponentName"/> values are the same. </summary>
        public static bool operator ==(WindowsSetupAdditionalInformationComponentName left, WindowsSetupAdditionalInformationComponentName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WindowsSetupAdditionalInformationComponentName"/> values are not the same. </summary>
        public static bool operator !=(WindowsSetupAdditionalInformationComponentName left, WindowsSetupAdditionalInformationComponentName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WindowsSetupAdditionalInformationComponentName"/>. </summary>
        public static implicit operator WindowsSetupAdditionalInformationComponentName(string value) => new WindowsSetupAdditionalInformationComponentName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WindowsSetupAdditionalInformationComponentName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WindowsSetupAdditionalInformationComponentName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
